-- SmartBake360 — core schema (simplified, extend as needed)

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  role VARCHAR(50) NOT NULL DEFAULT 'Manager',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO users (username, password_hash, role)
VALUES ('admin', '$2y$10$yH9EjpHnWv3aYf7S1H1FoeLh1QO8u0u7vYHqN16nq7F9xXkXxXxXx', 'Admin')
ON DUPLICATE KEY UPDATE username = username;

CREATE TABLE IF NOT EXISTS branches (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(50) NOT NULL,
  branch_name VARCHAR(100) NOT NULL,
  location VARCHAR(100) DEFAULT NULL
);

CREATE TABLE IF NOT EXISTS vehicles (
  id INT AUTO_INCREMENT PRIMARY KEY,
  reg_no VARCHAR(50) NOT NULL,
  description VARCHAR(100) DEFAULT NULL,
  capacity VARCHAR(50) DEFAULT NULL
);

CREATE TABLE IF NOT EXISTS riders (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(50) NOT NULL,
  name VARCHAR(100) NOT NULL,
  phone VARCHAR(30) DEFAULT NULL,
  vehicle_assigned VARCHAR(50) DEFAULT NULL
);

CREATE TABLE IF NOT EXISTS customers (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(50) NOT NULL,
  name VARCHAR(100) NOT NULL,
  category VARCHAR(50) DEFAULT NULL,
  phone VARCHAR(30) DEFAULT NULL,
  route VARCHAR(50) DEFAULT NULL
);

CREATE TABLE IF NOT EXISTS suppliers (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(50) NOT NULL,
  name VARCHAR(100) NOT NULL,
  phone VARCHAR(30) DEFAULT NULL,
  contact_person VARCHAR(100) DEFAULT NULL
);

CREATE TABLE IF NOT EXISTS products (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(50) NOT NULL,
  name VARCHAR(100) NOT NULL,
  category VARCHAR(50) NOT NULL,
  uom VARCHAR(20) NOT NULL DEFAULT 'PC',
  status VARCHAR(20) NOT NULL DEFAULT 'Active'
);

CREATE TABLE IF NOT EXISTS raw_materials (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(50) NOT NULL,
  name VARCHAR(100) NOT NULL,
  uom VARCHAR(20) NOT NULL,
  current_stock DECIMAL(12,3) NOT NULL DEFAULT 0
);

CREATE TABLE IF NOT EXISTS recipes (
  id INT AUTO_INCREMENT PRIMARY KEY,
  product_id INT NOT NULL,
  code VARCHAR(50) NOT NULL,
  name VARCHAR(100) NOT NULL,
  yield_qty INT NOT NULL,
  CONSTRAINT fk_recipes_product FOREIGN KEY (product_id) REFERENCES products(id)
);

CREATE TABLE IF NOT EXISTS recipe_items (
  id INT AUTO_INCREMENT PRIMARY KEY,
  recipe_id INT NOT NULL,
  material_id INT NOT NULL,
  qty DECIMAL(12,3) NOT NULL,
  CONSTRAINT fk_ritem_recipe FOREIGN KEY (recipe_id) REFERENCES recipes(id),
  CONSTRAINT fk_ritem_material FOREIGN KEY (material_id) REFERENCES raw_materials(id)
);

CREATE TABLE IF NOT EXISTS production_batches (
  id INT AUTO_INCREMENT PRIMARY KEY,
  batch_date DATE NOT NULL,
  batch_no VARCHAR(50) NOT NULL,
  product_id INT NOT NULL,
  planned_qty INT NOT NULL DEFAULT 0,
  actual_qty INT NOT NULL DEFAULT 0,
  oven VARCHAR(50) DEFAULT NULL,
  notes VARCHAR(255) DEFAULT NULL,
  CONSTRAINT fk_batch_product FOREIGN KEY (product_id) REFERENCES products(id)
);
