<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id = (int)($_POST['id'] ?? 0);
$product_id = (int)($_POST['product_id'] ?? 0);
$code = trim($_POST['code'] ?? '');
$name = trim($_POST['name'] ?? '');
$yield_qty = (int)($_POST['yield_qty'] ?? 0);

if (!$product_id || !$code || !$name || $yield_qty <= 0) {
    flash_set('error', 'Fill all mandatory fields.');
    redirect("recipes_form.php" . ($id ? "?id=".$id : ""));
}

if ($id) {
    $stmt = $conn->prepare("UPDATE recipes SET product_id=?, code=?, name=?, yield_qty=? WHERE id=?");
    $stmt->bind_param("issii", $product_id, $code, $name, $yield_qty, $id);
    $stmt->execute();
    flash_set('success', 'Recipe updated.');
} else {
    $stmt = $conn->prepare("INSERT INTO recipes (product_id, code, name, yield_qty) VALUES (?,?,?,?)");
    $stmt->bind_param("issi", $product_id, $code, $name, $yield_qty);
    $stmt->execute();
    flash_set('success', 'Recipe created.');
}
redirect("recipes_list.php");
