<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$page_title = "Recipes & BOM";
$sql = "SELECT r.*, p.name AS product_name FROM recipes r JOIN products p ON r.product_id = p.id ORDER BY r.id DESC";
$res = $conn->query($sql);
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Recipes &amp; BOM</h5>
      <p class="small text-muted mb-0">Define ingredient breakdown and yield for every bread, cake, and pastry SKU.</p>
    </div>
    <a href="recipes_form.php" class="btn btn-sm btn-primary rounded-pill" style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
      <i class="fa-solid fa-plus me-1"></i> New Recipe
    </a>
  </div>
  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Code</th>
          <th>Product</th>
          <th>Yield Qty</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php while($r = $res->fetch_assoc()): ?>
        <tr>
          <td><?php echo h($r['code']); ?></td>
          <td><?php echo h($r['product_name']); ?></td>
          <td><?php echo (int)$r['yield_qty']; ?> pcs</td>
          <td class="text-end">
            <a href="recipes_form.php?id=<?php echo $r['id']; ?>" class="btn btn-sm btn-outline-light rounded-pill"><i class="fa-regular fa-pen-to-square"></i></a>
            <a href="items_list.php?recipe_id=<?php echo $r['id']; ?>" class="btn btn-sm btn-outline-success rounded-pill"><i class="fa-solid fa-carrot"></i> Ingredients</a>
          </td>
        </tr>
        <?php endwhile; ?>
        <?php if ($res->num_rows === 0): ?>
          <tr><td colspan="4" class="text-center text-muted py-3">No recipes yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
