<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_token();
$page_title = "Recipe Header";

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$row = [];
if ($id) {
    $stmt = $conn->prepare("SELECT * FROM recipes WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    if (!$row) $id = 0;
}
$products = $conn->query("SELECT id, code, name FROM products WHERE status='Active' ORDER BY name")->fetch_all(MYSQLI_ASSOC);
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="row justify-content-center">
  <div class="col-lg-6 col-md-8">
    <div class="sb-card">
      <h5 class="mb-2"><?php echo $id ? "Edit" : "New"; ?> Recipe</h5>
      <form method="post" action="recipes_save.php" class="small">
        <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
        <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">
        <div class="mb-2">
          <label class="form-label">Product</label>
          <select name="product_id" class="form-select form-select-sm" required>
            <option value="">-- choose product --</option>
            <?php foreach($products as $p): ?>
              <option value="<?php echo $p['id']; ?>" <?php echo ($row['product_id'] ?? 0) == $p['id'] ? 'selected' : ''; ?>>
                <?php echo h($p['code'] . " — " . $p['name']); ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="mb-2">
          <label class="form-label">Recipe Code</label>
          <input type="text" name="code" class="form-control form-control-sm" value="<?php echo h($row['code'] ?? ''); ?>" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Recipe Name</label>
          <input type="text" name="name" class="form-control form-control-sm" value="<?php echo h($row['name'] ?? ''); ?>" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Yield Quantity (pcs)</label>
          <input type="number" name="yield_qty" class="form-control form-control-sm" value="<?php echo h($row['yield_qty'] ?? '0'); ?>" min="1" required>
        </div>
        <div class="d-flex justify-content-between align-items-center mt-3">
          <a href="recipes_list.php" class="btn btn-sm btn-outline-light rounded-pill">
            <i class="fa-solid fa-arrow-left-long me-1"></i> Back
          </a>
          <button type="submit" class="btn btn-sm btn-primary rounded-pill" style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
            <i class="fa-solid fa-floppy-disk me-1"></i> Save
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
