<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$page_title = "Production Batches";

$sql = "SELECT b.*, p.name AS product_name, p.code AS product_code
        FROM production_batches b
        JOIN products p ON b.product_id = p.id
        ORDER BY b.batch_date DESC, b.id DESC";

$res = $conn->query($sql);
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Production Batches</h5>
      <p class="small text-muted mb-0">
        Plan and track all bread / cake batches. Post to stock when confirmed.
      </p>
    </div>
    <a href="batch_form.php" class="btn btn-sm btn-primary rounded-pill"
       style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
      <i class="fa-solid fa-plus me-1"></i> New Batch
    </a>
  </div>
  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Date</th>
          <th>Batch No</th>
          <th>Product</th>
          <th class="text-end">Planned</th>
          <th class="text-end">Actual</th>
          <th>Oven</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php while($b = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo h($b['batch_date']); ?></td>
            <td><?php echo h($b['batch_no']); ?></td>
            <td>
              <strong><?php echo h($b['product_code']); ?></strong><br>
              <span class="text-muted"><?php echo h($b['product_name']); ?></span>
            </td>
            <td class="text-end"><?php echo (int)$b['planned_qty']; ?></td>
            <td class="text-end"><?php echo (int)$b['actual_qty']; ?></td>
            <td><?php echo h($b['oven']); ?></td>
            <td>
              <?php if ($b['status'] === 'Posted'): ?>
                <span class="badge rounded-pill text-bg-success-subtle border border-success-subtle">
                  <i class="fa-solid fa-circle-check me-1"></i> Posted
                </span>
              <?php else: ?>
                <span class="badge rounded-pill text-bg-warning-subtle border border-warning-subtle">
                  <i class="fa-solid fa-circle-half-stroke me-1"></i> Draft
                </span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <div class="btn-group btn-group-sm">
                <a href="batch_form.php?id=<?php echo $b['id']; ?>"
                   class="btn btn-outline-light rounded-pill">
                  <i class="fa-regular fa-pen-to-square"></i>
                </a>
                <?php if ($b['status'] !== 'Posted'): ?>
                  <a href="post_to_stock.php?id=<?php echo $b['id']; ?>"
                     class="btn btn-outline-success rounded-pill"
                     onclick="return confirm('Post this batch to stock? This will consume ingredients and add finished goods.');">
                    <i class="fa-solid fa-arrow-up-right-from-square"></i> Post
                  </a>
                <?php endif; ?>
              </div>
            </td>
          </tr>
        <?php endwhile; ?>
        <?php if ($res->num_rows === 0): ?>
          <tr><td colspan="8" class="text-center text-muted py-3">No batches yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
