<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$page_title = "POS Sales";

$sql = "
  SELECT *
  FROM pos_sales
  ORDER BY sale_date DESC, id DESC
  LIMIT 100
";
$res = $conn->query($sql);
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">POS Sales</h5>
      <p class="small text-muted mb-0">
        Recent over-the-counter sales captured from the Counter POS.
      </p>
    </div>
  </div>
  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Date</th>
          <th>Receipt</th>
          <th>Customer</th>
          <th>Payment Mode</th>
          <th class="text-end">Cash</th>
          <th class="text-end">Mpesa</th>
          <th class="text-end">Total</th>
        </tr>
      </thead>
      <tbody>
        <?php while($row = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo h($row['sale_date']); ?></td>
            <td><?php echo h($row['receipt_no']); ?></td>
            <td><?php echo h($row['customer_name'] ?: 'Walk-in'); ?></td>
            <td><?php echo h($row['payment_mode']); ?></td>
            <td class="text-end"><?php echo number_format($row['cash_amount'], 2); ?></td>
            <td class="text-end"><?php echo number_format($row['mpesa_amount'], 2); ?></td>
            <td class="text-end"><?php echo number_format($row['total_amount'], 2); ?></td>
          </tr>
        <?php endwhile; ?>
        <?php if ($res->num_rows === 0): ?>
          <tr><td colspan="7" class="text-center text-muted py-3">No POS sales yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
