<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_token();

$page_title = "Counter POS";

// Load active products
$sql = "
  SELECT id, code, name, category, selling_price
  FROM products
  WHERE status = 'Active'
  ORDER BY category, name
";
$res = $conn->query($sql);
$products = $res->fetch_all(MYSQLI_ASSOC);

$byCategory = [];
foreach ($products as $p) {
    $byCategory[$p['category']][] = $p;
}

// Load open cake orders to pay at POS
$cakeOrders = $conn->query("
  SELECT id, order_no, customer_name, event_date, status,
         total_amount, deposit_amount, balance_amount
  FROM cake_orders
  WHERE status IN ('Enquiry','Confirmed','In Production','Ready')
  ORDER BY event_date, id DESC
")->fetch_all(MYSQLI_ASSOC);

$cashier = $_SESSION['username'] ?? 'Cashier';
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Counter POS</h5>
      <p class="small text-muted mb-0">
        Fast counter sales &amp; cake payments in one screen.
      </p>
    </div>
    <div class="text-end small">
      <div>Cashier: <strong><?php echo h($cashier); ?></strong></div>
      <div>Date: <strong><?php echo date('Y-m-d H:i'); ?></strong></div>
    </div>
  </div>

  <!-- Mode toggle -->
  <div class="mb-3">
    <div class="btn-group w-100" role="group">
      <button type="button"
              class="btn btn-sm btn-primary mode-btn active"
              data-mode="normal">
        <i class="fa-solid fa-cart-shopping me-1"></i> Normal Sale
      </button>
      <button type="button"
              class="btn btn-sm btn-outline-light mode-btn"
              data-mode="cake">
        <i class="fa-solid fa-cake-candles me-1"></i> Cake Payment
      </button>
    </div>
    <input type="hidden" name="mode" id="posMode" form="posForm" value="normal">
  </div>

  <form method="post" action="pos_save.php" class="small" id="posForm">
    <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">

    <!-- Shared header info -->
    <div class="row g-2 mb-2">
      <div class="col-md-3">
        <label class="form-label mb-1">Sale Date &amp; Time</label>
        <input type="text" name="sale_date" class="form-control form-control-sm"
               value="<?php echo date('Y-m-d H:i:s'); ?>">
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Receipt No</label>
        <input type="text" name="receipt_no" class="form-control form-control-sm"
               value="<?php echo 'POS-' . date('ymd-His'); ?>">
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Customer (optional)</label>
        <input type="text" name="customer_name" class="form-control form-control-sm"
               id="customerNameInput"
               placeholder="Walk-in">
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Payment Mode</label>
        <select name="payment_mode" class="form-select form-select-sm" id="paymentModeSelect">
          <option value="Cash">Cash</option>
          <option value="Mpesa">Mpesa</option>
          <option value="Mixed">Mixed</option>
        </select>
      </div>
    </div>

    <!-- CAKE PAYMENT SECTION -->
    <div id="cakeSection" class="border rounded-4 p-2 mb-3 d-none bg-dark bg-opacity-25">
      <h6 class="text-uppercase text-muted small mb-2">
        <i class="fa-solid fa-cake-candles me-1"></i> Cake Order Payment
      </h6>

      <div class="row g-2 align-items-end">
        <div class="col-md-6">
          <label class="form-label mb-1">Select Cake Order</label>
          <select name="cake_order_id" id="cakeOrderSelect" class="form-select form-select-sm">
            <option value="">-- Choose cake order --</option>
            <?php foreach ($cakeOrders as $co): ?>
              <option value="<?php echo $co['id']; ?>"
                data-customer="<?php echo h($co['customer_name']); ?>"
                data-total="<?php echo h($co['total_amount']); ?>"
                data-paid="<?php echo h($co['deposit_amount']); ?>"
                data-balance="<?php echo h($co['balance_amount']); ?>">
                <?php
                  echo h($co['order_no']) . " • " .
                       h($co['customer_name']) . " • " .
                       "Event: " . h($co['event_date']) . " • " .
                       "Bal: " . number_format($co['balance_amount'], 2);
                ?>
              </option>
            <?php endforeach; ?>
          </select>
          <div class="form-text text-muted">
            User must have cake order already created.
          </div>
        </div>

        <div class="col-md-6">
          <div class="row g-2">
            <div class="col-4">
              <div class="p-1 rounded-3 border border-secondary">
                <div class="small text-muted text-uppercase">Total</div>
                <div class="fw-bold" id="cakeTotalText">KES 0.00</div>
              </div>
            </div>
            <div class="col-4">
              <div class="p-1 rounded-3 border border-success">
                <div class="small text-muted text-uppercase">Paid</div>
                <div class="fw-bold text-success" id="cakePaidText">KES 0.00</div>
              </div>
            </div>
            <div class="col-4">
              <div class="p-1 rounded-3 border border-warning">
                <div class="small text-muted text-uppercase">Balance</div>
                <div class="fw-bold text-warning" id="cakeBalanceText">KES 0.00</div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- we reuse payment card on the right -->
    </div>

    <hr class="border-secondary my-3">

    <div class="row g-3">
      <!-- NORMAL SALE ITEMS -->
      <div class="col-lg-7">
        <div id="normalItemsSection">
          <h6 class="text-uppercase text-muted small mb-2">Items (Normal Counter Sale)</h6>
          <div class="table-responsive small mb-2">
            <table class="table table-dark table-borderless align-middle mb-0" id="itemsTable">
              <thead class="text-muted text-uppercase small">
                <tr>
                  <th style="width:40%;">Product</th>
                  <th class="text-end" style="width:15%;">Qty</th>
                  <th class="text-end" style="width:20%;">Unit Price</th>
                  <th class="text-end" style="width:20%;">Line Total</th>
                  <th style="width:5%;"></th>
                </tr>
              </thead>
              <tbody id="itemsTableBody">
                <tr class="pos-row">
                  <td>
                    <select name="product_id[]" class="form-select form-select-sm product-select">
                      <option value="">-- select --</option>
                      <?php foreach($byCategory as $cat => $rows): ?>
                        <optgroup label="<?php echo h($cat); ?>">
                          <?php foreach($rows as $p): ?>
                            <option value="<?php echo $p['id']; ?>"
                                    data-price="<?php echo h($p['selling_price']); ?>">
                              <?php echo h($p['code'] . ' — ' . $p['name']); ?>
                            </option>
                          <?php endforeach; ?>
                        </optgroup>
                      <?php endforeach; ?>
                    </select>
                  </td>
                  <td class="text-end">
                    <input type="number" name="qty[]" class="form-control form-control-sm text-end qty-input"
                           value="0" min="0" step="1">
                  </td>
                  <td class="text-end">
                    <input type="number" name="unit_price[]" class="form-control form-control-sm text-end price-input"
                           value="0.00" step="0.01">
                  </td>
                  <td class="text-end">
                    <input type="text" class="form-control form-control-sm text-end line-total" value="0.00" readonly>
                  </td>
                  <td class="text-center">
                    <button type="button" class="btn btn-sm btn-outline-light rounded-pill btn-clear-row">
                      <i class="fa-solid fa-xmark"></i>
                    </button>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          <p class="small text-muted mb-0">
            In <strong>Normal Sale</strong> mode: once you choose a product or qty on the last row,
            a new blank row will appear automatically.  
            Press <strong>Enter</strong> on an empty row to go to payment.
          </p>
        </div>

        <div id="cakeItemsHint" class="d-none">
          <div class="alert alert-info py-2 px-3 small mb-0">
            <i class="fa-solid fa-circle-info me-1"></i>
            In <strong>Cake Payment</strong> mode, you don't need to enter items here.
            The system only records a payment against the selected cake order.
          </div>
        </div>
      </div>

      <!-- RIGHT COLUMN: PAYMENTS -->
      <div class="col-lg-5">
        <h6 class="text-uppercase text-muted small mb-2">Payments</h6>

        <!-- Payment card (used for both modes) -->
        <div class="border rounded-4 p-3 bg-dark bg-opacity-50 mb-3" id="normalPaymentCard">
          <div class="mb-2 d-flex justify-content-between">
            <span>Sub Total (items)</span>
            <strong id="subTotalText">KES 0.00</strong>
          </div>
          <div class="mb-2">
            <label class="form-label mb-1">Cash Amount</label>
            <input type="number" step="0.01" name="cash_amount" id="cashAmount"
                   class="form-control form-control-sm text-end" value="0.00">
          </div>
          <div class="mb-2">
            <label class="form-label mb-1">Mpesa Amount</label>
            <input type="number" step="0.01" name="mpesa_amount" id="mpesaAmount"
                   class="form-control form-control-sm text-end" value="0.00">
          </div>
          <div class="mb-2 d-flex justify-content-between">
            <span>Paid Total</span>
            <strong id="paidTotalText">KES 0.00</strong>
          </div>
          <div class="mb-0 d-flex justify-content-between">
            <span>Change (Paid - SubTotal)</span>
            <strong id="changeText">KES 0.00</strong>
          </div>
        </div>

        <!-- Cake-friendly helper UI (on top of same cash/mpesa inputs) -->
        <div class="border rounded-4 p-3 bg-dark bg-opacity-50 mb-3 d-none" id="cakePaymentHelper">
          <div class="mb-2">
            <label class="form-label mb-1">Amount to pay now (KES)</label>
            <input type="number" step="0.01" class="form-control form-control-sm text-end"
                   id="cakePayAmount" value="0.00">
            <div class="form-text">
              Default will be current cake balance. Adjust for partial payment.
            </div>
          </div>

          <div class="mb-2">
            <label class="form-label mb-1">Quick Method</label>
            <div class="d-flex gap-2">
              <button type="button"
                      class="btn btn-sm btn-outline-light w-50 cake-method-btn active"
                      data-method="Cash">
                <i class="fa-solid fa-money-bill-wave me-1"></i> Cash
              </button>
              <button type="button"
                      class="btn btn-sm btn-outline-light w-50 cake-method-btn"
                      data-method="Mpesa">
                <i class="fa-solid fa-mobile-screen-button me-1"></i> Mpesa
              </button>
            </div>
          </div>

          <p class="small text-muted mb-0">
            We will fill <strong>Cash / Mpesa</strong> fields for you and link this
            payment to the selected cake order.
          </p>
        </div>

        <div class="d-flex justify-content-between align-items-center">
          <button type="reset" class="btn btn-sm btn-outline-light rounded-pill" id="btnClear">
            <i class="fa-solid fa-broom me-1"></i> Clear
          </button>
          <button type="submit" class="btn btn-lg btn-success rounded-pill px-4">
            <i class="fa-solid fa-receipt me-1"></i> Complete
          </button>
        </div>
      </div>
    </div>
  </form>
</div>

<!-- Payment popup modal (center) -->
<div class="modal fade" id="paymentModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content bg-dark text-light border border-secondary">
      <div class="modal-header">
        <h5 class="modal-title">
          <i class="fa-solid fa-money-check-dollar me-2"></i> Proceed to Payment
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p class="mb-1">
          Subtotal for this sale:
        </p>
        <p class="fs-5 fw-bold mb-2" id="modalSubTotalText">KES 0.00</p>
        <p class="small text-muted mb-0">
          Fill <strong>Cash / Mpesa</strong> on the right, then click
          <strong>Complete</strong> to save and print.
        </p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-sm btn-outline-light" data-bs-dismiss="modal">
          Cancel
        </button>
        <button type="button" class="btn btn-sm btn-success" id="goToPaymentBtn">
          Go to payment
        </button>
      </div>
    </div>
  </div>
</div>

<script>
(function() {
  const modeInput = document.getElementById('posMode');
  const cakeSection = document.getElementById('cakeSection');
  const normalItems = document.getElementById('normalItemsSection');
  const cakeItemsHint = document.getElementById('cakeItemsHint');
  const normalPaymentCard = document.getElementById('normalPaymentCard');
  const cakePaymentHelper = document.getElementById('cakePaymentHelper');
  const cakeOrderSelect = document.getElementById('cakeOrderSelect');
  const customerNameInput = document.getElementById('customerNameInput');
  const paymentModeSelect = document.getElementById('paymentModeSelect');

  const cakeTotalText = document.getElementById('cakeTotalText');
  const cakePaidText = document.getElementById('cakePaidText');
  const cakeBalanceText = document.getElementById('cakeBalanceText');
  const cakePayAmount = document.getElementById('cakePayAmount');

  const cashAmountInput = document.getElementById('cashAmount');
  const mpesaAmountInput = document.getElementById('mpesaAmount');

  const itemsBody = document.getElementById('itemsTableBody');

  // Bootstrap modal
  let paymentModal = null;
  if (window.bootstrap && document.getElementById('paymentModal')) {
    paymentModal = new bootstrap.Modal(document.getElementById('paymentModal'));
  }

  function openPaymentModal() {
    if (!paymentModal) return;
    const subText = document.getElementById('subTotalText').textContent || 'KES 0.00';
    document.getElementById('modalSubTotalText').textContent = subText;
    paymentModal.show();
  }

  const goToPaymentBtn = document.getElementById('goToPaymentBtn');
  if (goToPaymentBtn) {
    goToPaymentBtn.addEventListener('click', function() {
      if (paymentModal) paymentModal.hide();
      if (cashAmountInput) cashAmountInput.focus();
    });
  }

  // -------- MODE TOGGLE --------
  document.querySelectorAll('.mode-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      document.querySelectorAll('.mode-btn').forEach(b => b.classList.remove('btn-primary', 'active'));
      document.querySelectorAll('.mode-btn').forEach(b => b.classList.add('btn-outline-light'));
      this.classList.add('btn-primary', 'active');
      this.classList.remove('btn-outline-light');

      const mode = this.dataset.mode;
      modeInput.value = mode;

      if (mode === 'normal') {
        cakeSection.classList.add('d-none');
        cakeItemsHint.classList.add('d-none');
        cakePaymentHelper.classList.add('d-none');
        normalItems.classList.remove('d-none');
        normalPaymentCard.classList.remove('d-none');
      } else {
        cakeSection.classList.remove('d-none');
        cakeItemsHint.classList.remove('d-none');
        cakePaymentHelper.classList.remove('d-none');
        normalItems.classList.add('d-none');
        normalPaymentCard.classList.remove('d-none');
      }
    });
  });

  // -------- ITEMS & TOTALS (NORMAL) --------
  function recalcRow(tr) {
    const qtyEl   = tr.querySelector('.qty-input');
    const priceEl = tr.querySelector('.price-input');
    const lineEl  = tr.querySelector('.line-total');

    const qty   = parseFloat(qtyEl.value)   || 0;
    const price = parseFloat(priceEl.value) || 0;
    const total = qty * price;
    lineEl.value = total.toFixed(2);
  }

  function recalcTotals() {
    let sub = 0;
    itemsBody.querySelectorAll('.line-total').forEach(function(el) {
      const v = parseFloat(el.value) || 0;
      sub += v;
    });
    document.getElementById('subTotalText').textContent = 'KES ' + sub.toFixed(2);

    const cash  = parseFloat(cashAmountInput.value)  || 0;
    const mpesa = parseFloat(mpesaAmountInput.value) || 0;
    const paid  = cash + mpesa;
    document.getElementById('paidTotalText').textContent = 'KES ' + paid.toFixed(2);

    const change = paid - sub;
    document.getElementById('changeText').textContent = 'KES ' + change.toFixed(2);
  }

  function isRowEmpty(tr) {
    const prodSel = tr.querySelector('.product-select');
    const qtyEl   = tr.querySelector('.qty-input');
    const priceEl = tr.querySelector('.price-input');

    const prodVal = prodSel ? prodSel.value : '';
    const qtyVal  = qtyEl ? parseFloat(qtyEl.value || '0') : 0;
    const priceVal= priceEl ? parseFloat(priceEl.value || '0') : 0;

    return (!prodVal && qtyVal === 0 && priceVal === 0);
  }

  function hasAnyFilledRow() {
    const rows = itemsBody.querySelectorAll('tr.pos-row');
    for (const r of rows) {
      if (!isRowEmpty(r)) return true;
    }
    return false;
  }

  function isLastRow(tr) {
    return tr === itemsBody.lastElementChild;
  }

  function addEmptyRow() {
    const rows = itemsBody.querySelectorAll('tr.pos-row');
    if (rows.length === 0) return;
    const template = rows[0];
    const clone = template.cloneNode(true);

    // reset values
    clone.querySelectorAll('select, input').forEach(el => {
      if (el.classList.contains('product-select')) {
        el.value = '';
      } else if (el.classList.contains('qty-input')) {
        el.value = '0';
      } else if (el.classList.contains('price-input')) {
        el.value = '0.00';
      } else if (el.classList.contains('line-total')) {
        el.value = '0.00';
      }
    });

    attachRowEvents(clone);
    itemsBody.appendChild(clone);
  }

  function attachRowEvents(tr) {
    const prodSel = tr.querySelector('.product-select');
    const qtyEl   = tr.querySelector('.qty-input');
    const priceEl = tr.querySelector('.price-input');
    const clearBtn= tr.querySelector('.btn-clear-row');

    if (!prodSel || !qtyEl || !priceEl || !clearBtn) return;

    prodSel.addEventListener('change', function() {
      const opt = prodSel.selectedOptions[0];
      if (opt && opt.dataset.price) {
        priceEl.value = parseFloat(opt.dataset.price).toFixed(2);
      }
      if (!qtyEl.value || qtyEl.value === '0') qtyEl.value = 1;
      recalcRow(tr);
      recalcTotals();

      // if last row and now not empty, create a new row
      if (isLastRow(tr) && !isRowEmpty(tr)) {
        addEmptyRow();
      }
    });

    qtyEl.addEventListener('input', function() {
      recalcRow(tr);
      recalcTotals();

      if (isLastRow(tr) && !isRowEmpty(tr)) {
        addEmptyRow();
      }
    });

    priceEl.addEventListener('input', function() {
      recalcRow(tr);
      recalcTotals();

      if (isLastRow(tr) && !isRowEmpty(tr)) {
        addEmptyRow();
      }
    });

    clearBtn.addEventListener('click', function() {
      const rows = itemsBody.querySelectorAll('tr.pos-row');
      if (rows.length > 1) {
        tr.remove();
      } else {
        // reset the only row
        prodSel.value = '';
        qtyEl.value = '0';
        priceEl.value = '0.00';
        tr.querySelector('.line-total').value = '0.00';
      }
      recalcTotals();
    });

    // ENTER behaviour on a plain row → open payment modal
    [prodSel, qtyEl, priceEl].forEach(el => {
      el.addEventListener('keydown', function(e) {
        if (e.key === 'Enter') {
          const mode = modeInput.value || 'normal';
          if (mode !== 'normal') return;

          // only if this row is empty and there is at least one filled row
          if (isRowEmpty(tr) && hasAnyFilledRow()) {
            e.preventDefault();
            openPaymentModal();
          }
        }
      });
    });
  }

  // attach events to initial row
  itemsBody.querySelectorAll('tr.pos-row').forEach(tr => attachRowEvents(tr));

  cashAmountInput.addEventListener('input', recalcTotals);
  mpesaAmountInput.addEventListener('input', recalcTotals);

  // -------- CAKE ORDER SELECTION --------
  if (cakeOrderSelect) {
    cakeOrderSelect.addEventListener('change', function() {
      const opt = this.selectedOptions[0];
      if (!opt || !opt.value) {
        cakeTotalText.textContent = 'KES 0.00';
        cakePaidText.textContent = 'KES 0.00';
        cakeBalanceText.textContent = 'KES 0.00';
        if (cakePayAmount) cakePayAmount.value = '0.00';
        customerNameInput.value = '';
        return;
      }
      const total   = parseFloat(opt.dataset.total || 0);
      const paid    = parseFloat(opt.dataset.paid || 0);
      const balance = parseFloat(opt.dataset.balance || 0);
      const cust    = opt.dataset.customer || '';

      cakeTotalText.textContent   = 'KES ' + total.toFixed(2);
      cakePaidText.textContent    = 'KES ' + paid.toFixed(2);
      cakeBalanceText.textContent = 'KES ' + balance.toFixed(2);

      // Set default amount to current balance
      if (cakePayAmount) {
        cakePayAmount.value = balance.toFixed(2);
      }

      // Auto-fill customer
      if (cust && !customerNameInput.value) {
        customerNameInput.value = cust;
      }

      // Default payment mode to Cash
      paymentModeSelect.value = 'Cash';
      applyCakeAmountToCashMpesa();
    });
  }

  // -------- CAKE PAYMENT HELPER --------
  function applyCakeAmountToCashMpesa() {
    if (!cakePayAmount) return;
    const amt = parseFloat(cakePayAmount.value) || 0;
    const activeBtn = document.querySelector('.cake-method-btn.active');
    const method = activeBtn ? activeBtn.dataset.method : 'Cash';

    if (method === 'Mpesa') {
      cashAmountInput.value = '0.00';
      mpesaAmountInput.value = amt.toFixed(2);
      paymentModeSelect.value = 'Mpesa';
    } else {
      cashAmountInput.value = amt.toFixed(2);
      mpesaAmountInput.value = '0.00';
      paymentModeSelect.value = 'Cash';
    }
    recalcTotals();
  }

  document.querySelectorAll('.cake-method-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      document.querySelectorAll('.cake-method-btn').forEach(b => b.classList.remove('active', 'btn-primary'));
      document.querySelectorAll('.cake-method-btn').forEach(b => b.classList.add('btn-outline-light'));
      this.classList.add('active', 'btn-primary');
      this.classList.remove('btn-outline-light');
      applyCakeAmountToCashMpesa();
    });
  });

  if (cakePayAmount) {
    cakePayAmount.addEventListener('input', applyCakeAmountToCashMpesa);
  }

  // Clear button reset extra helpers
  const btnClear = document.getElementById('btnClear');
  if (btnClear) {
    btnClear.addEventListener('click', function() {
      setTimeout(function() {
        recalcTotals();
        if (cakePayAmount) cakePayAmount.value = '0.00';
        if (cakeOrderSelect) cakeOrderSelect.value = '';
        cakeTotalText.textContent = 'KES 0.00';
        cakePaidText.textContent = 'KES 0.00';
        cakeBalanceText.textContent = 'KES 0.00';
      }, 50);
    });
  }

  // Initial calculation
  recalcTotals();
})();
</script>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
