<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_token();
$page_title = "Edit Suppliers";

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$row = [];
if ($id) {
    $stmt = $conn->prepare("SELECT * FROM suppliers WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    if (!$row) $id = 0;
}
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="row justify-content-center">
  <div class="col-lg-6 col-md-8">
    <div class="sb-card">
      <h5 class="mb-2"><?php echo $id ? "Edit" : "New"; ?> Suppliers</h5>
      <form method="post" action="suppliers_save.php" class="small">
        <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
        <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">

          <div class="mb-2">
            <label class="form-label">Code</label>
            <input type="text" name="code" class="form-control form-control-sm" value="<?php echo h($row['code'] ?? ''); ?>">
          </div>

          <div class="mb-2">
            <label class="form-label">Name</label>
            <input type="text" name="name" class="form-control form-control-sm" value="<?php echo h($row['name'] ?? ''); ?>">
          </div>

          <div class="mb-2">
            <label class="form-label">Phone</label>
            <input type="text" name="phone" class="form-control form-control-sm" value="<?php echo h($row['phone'] ?? ''); ?>">
          </div>

          <div class="mb-2">
            <label class="form-label">Contact Person</label>
            <input type="text" name="contact_person" class="form-control form-control-sm" value="<?php echo h($row['contact_person'] ?? ''); ?>">
          </div>

        <div class="d-flex justify-content-between align-items-center mt-3">
          <a href="suppliers_list.php" class="btn btn-sm btn-outline-light rounded-pill">
            <i class="fa-solid fa-arrow-left-long me-1"></i> Back
          </a>
          <div class="d-flex gap-2">
            <?php if ($id): ?>
            <a href="suppliers_delete.php?id=<?php echo $id; ?>" class="btn btn-sm btn-outline-danger rounded-pill" onclick="return confirm('Delete this record?');">
              <i class="fa-solid fa-trash-can"></i>
            </a>
            <?php endif; ?>
            <button type="submit" class="btn btn-sm btn-primary rounded-pill" style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
              <i class="fa-solid fa-floppy-disk me-1"></i> Save
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
