<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$page_title = "Riders & Sales Staff";
$res = $conn->query("SELECT * FROM riders ORDER BY id DESC");
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Riders & Sales Staff</h5>
      <p class="small text-muted mb-0">Manage riders & sales staff used across SmartBake360.</p>
    </div>
    <a href="riders_form.php" class="btn btn-sm btn-primary rounded-pill" style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
      <i class="fa-solid fa-plus me-1"></i> New
    </a>
  </div>
  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Code</th>
          <th>Name</th>
          <th>Phone</th>
          <th>Vehicle Assigned</th>
          <th style="width:60px;"></th>
        </tr>
      </thead>
      <tbody>
      <?php while($row = $res->fetch_assoc()): ?>
        <tr>
          <td><?php echo h($row["code"]); ?></td>
          <td><?php echo h($row["name"]); ?></td>
          <td><?php echo h($row["phone"]); ?></td>
          <td><?php echo h($row["vehicle_assigned"]); ?></td>
          <td class="text-end">
            <a href="riders_form.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-light rounded-pill"><i class="fa-regular fa-pen-to-square"></i></a>
          </td>
        </tr>
      <?php endwhile; ?>
      <?php if ($res->num_rows === 0): ?>
        <tr><td colspan="5" class="text-center text-muted py-3">No records yet.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
