<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
$page_title = "Products (SKUs)";
$res = $conn->query("SELECT * FROM products ORDER BY category, name");
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div>
      <h5 class="mb-0">Products (SKUs)</h5>
      <p class="small text-muted mb-0">
        Bread sizes, cakes, cookies, pastries with selling price per piece.
      </p>
    </div>
    <a href="products_form.php" class="btn btn-sm btn-primary rounded-pill"
       style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
      <i class="fa-solid fa-plus me-1"></i> New Product
    </a>
  </div>
  <div class="table-responsive small">
    <table class="table table-dark table-borderless align-middle mb-0">
      <thead class="text-muted text-uppercase small">
        <tr>
          <th>Code</th>
          <th>Name</th>
          <th>Category</th>
          <th>UOM</th>
          <th class="text-end">Selling Price (KES)</th>
          <th>Status</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php while($row = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo h($row['code']); ?></td>
            <td><?php echo h($row['name']); ?></td>
            <td><?php echo h($row['category']); ?></td>
            <td><?php echo h($row['uom']); ?></td>
            <td class="text-end"><?php echo number_format($row['selling_price'], 2); ?></td>
            <td><?php echo h($row['status']); ?></td>
            <td class="text-end">
              <a href="products_form.php?id=<?php echo $row['id']; ?>"
                 class="btn btn-sm btn-outline-light rounded-pill">
                <i class="fa-regular fa-pen-to-square"></i>
              </a>
            </td>
          </tr>
        <?php endwhile; ?>
        <?php if ($res->num_rows === 0): ?>
          <tr><td colspan="7" class="text-center text-muted py-3">No products yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
