<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_check();

$id          = (int)($_POST['id'] ?? 0);
$load_date   = $_POST['load_date'] ?? date('Y-m-d');
$load_no     = trim($_POST['load_no'] ?? '');
$vehicle_id  = ($_POST['vehicle_id'] ?? '') !== '' ? (int)$_POST['vehicle_id'] : null;
$rider_id    = ($_POST['rider_id'] ?? '')   !== '' ? (int)$_POST['rider_id']   : null;
$route_code  = trim($_POST['route_code'] ?? '');

if (!$load_no) {
    flash_set('error', 'Load number is required.');
    redirect("loading_form.php" . ($id ? "?id=".$id : ""));
}

// Save or update header
if ($id) {
    $stmt = $conn->prepare("UPDATE dispatch_loads 
        SET load_date=?, load_no=?, vehicle_id=?, rider_id=?, route_code=? 
        WHERE id=?");
    // s s i i s i
    $stmt->bind_param("ssiisi", $load_date, $load_no, $vehicle_id, $rider_id, $route_code, $id);
} else {
    $stmt = $conn->prepare("INSERT INTO dispatch_loads 
        (load_date, load_no, vehicle_id, rider_id, route_code) 
        VALUES (?,?,?,?,?)");
    // s s i i s
    $stmt->bind_param("ssiis", $load_date, $load_no, $vehicle_id, $rider_id, $route_code);
}
$stmt->execute();

if (!$id) {
    $id = $conn->insert_id;
}

// Handle adding item (but we do NOT post stock here)
if (isset($_POST['add_item']) && $_POST['add_item'] == '1') {
    $product_id = (int)($_POST['new_product_id'] ?? 0);
    $qty_loaded = (int)($_POST['new_qty_loaded'] ?? 0);

    if ($product_id && $qty_loaded > 0) {
        $stmt = $conn->prepare("INSERT INTO dispatch_load_items 
            (load_id, product_id, qty_loaded) VALUES (?,?,?)");
        $stmt->bind_param("iii", $id, $product_id, $qty_loaded);
        $stmt->execute();
        flash_set('success', 'Item added to loading.');
    } else {
        flash_set('error', 'Choose product and quantity.');
    }
    redirect("loading_form.php?id=".$id);
}

flash_set('success', 'Loading header saved.');
redirect("loadings_list.php");
