<?php
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";

$id = (int)($_GET['id'] ?? 0);
if (!$id) {
    die("Missing order id");
}

// Load order header
$stmt = $conn->prepare("
  SELECT co.*, c.code AS customer_code, c.name AS customer_master_name
  FROM cake_orders co
  LEFT JOIN customers c ON co.customer_id = c.id
  WHERE co.id = ?
");
$stmt->bind_param("i", $id);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();

if (!$order) {
    die("Order not found");
}

// Load items
$stmt = $conn->prepare("
  SELECT coi.*, p.code, p.name 
  FROM cake_order_items coi
  LEFT JOIN products p ON coi.product_id = p.id
  WHERE coi.cake_order_id = ?
");
$stmt->bind_param("i", $id);
$stmt->execute();
$items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// You can hardcode bakery name or later pull from app_settings
$bakery_name    = "SMARTBAKE360 BAKERY";
$bakery_tagline = "Cakes • Bread • Pastries";
$bakery_phone   = "Tel: 07xx xxx xxx";
$bakery_email   = "info@yourbakery.co.ke";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Cake Order <?php echo h($order['order_no']); ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * { box-sizing: border-box; }
    body {
      font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
      font-size: 12px;
      color: #111;
      margin: 0;
      padding: 0;
      background: #f3f3f3;
    }
    .page {
      width: 210mm;
      max-width: 100%;
      min-height: 148mm; /* A5-ish */
      margin: 10px auto;
      background: #fff;
      border-radius: 8px;
      border: 1px solid #ddd;
      padding: 16px 18px;
    }
    .header {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      border-bottom: 1px solid #ddd;
      padding-bottom: 8px;
      margin-bottom: 8px;
    }
    .brand h1 {
      font-size: 18px;
      margin: 0;
      letter-spacing: 1px;
      text-transform: uppercase;
    }
    .brand small {
      display: block;
      color: #777;
    }
    .doc-title {
      text-align: right;
      font-size: 16px;
      font-weight: 600;
      text-transform: uppercase;
    }
    .doc-title span {
      display: block;
      font-size: 11px;
      color: #777;
    }
    .row {
      display: flex;
      flex-wrap: wrap;
      margin: 0 -6px;
    }
    .col {
      padding: 0 6px;
      margin-bottom: 4px;
    }
    .col-6 { width: 50%; }
    .col-4 { width: 33.333%; }
    .col-12 { width: 100%; }
    .box {
      border: 1px solid #ddd;
      border-radius: 6px;
      padding: 6px 8px;
      margin-bottom: 4px;
    }
    h4.section-title {
      margin: 0 0 4px 0;
      font-size: 11px;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      color: #555;
    }
    .label {
      font-size: 10px;
      text-transform: uppercase;
      color: #777;
    }
    .value {
      font-size: 12px;
      font-weight: 500;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 4px;
    }
    th, td {
      border-bottom: 1px solid #eee;
      padding: 4px 2px;
      text-align: left;
      vertical-align: top;
    }
    th {
      font-size: 10px;
      text-transform: uppercase;
      color: #555;
    }
    td {
      font-size: 11px;
    }
    td.text-end {
      text-align: right;
    }
    .totals {
      margin-top: 6px;
      width: 50%;
      margin-left: auto;
    }
    .totals td {
      border: none;
      padding: 2px 0;
      font-size: 11px;
    }
    .totals .label {
      text-align: right;
      padding-right: 6px;
    }
    .totals .value {
      text-align: right;
      min-width: 60px;
    }
    .footer {
      margin-top: 8px;
      border-top: 1px dashed #ccc;
      padding-top: 6px;
      font-size: 10px;
      display: flex;
      justify-content: space-between;
    }
    .sign-box {
      width: 48%;
    }
    .sign-line {
      margin-top: 18px;
      border-top: 1px solid #000;
      width: 70%;
    }
    @media print {
      body {
        background: #fff;
      }
      .page {
        margin: 0;
        border: none;
        border-radius: 0;
        box-shadow: none;
        width: 100%;
      }
    }
  </style>
</head>
<body onload="window.print()">
<div class="page">
  <div class="header">
    <div class="brand">
      <h1><?php echo h($bakery_name); ?></h1>
      <small><?php echo h($bakery_tagline); ?></small>
      <small><?php echo h($bakery_phone); ?> · <?php echo h($bakery_email); ?></small>
    </div>
    <div class="doc-title">
      CAKE ORDER
      <span>No: <?php echo h($order['order_no']); ?></span>
      <span>Date: <?php echo h($order['order_date']); ?></span>
    </div>
  </div>

  <div class="row">
    <div class="col col-6">
      <div class="box">
        <h4 class="section-title">Customer Details</h4>
        <div>
          <div class="label">Customer</div>
          <div class="value">
            <?php
            if ($order['customer_code']) {
                echo h($order['customer_code']) . " — " . h($order['customer_master_name']);
            } else {
                echo h($order['customer_name']);
            }
            ?>
          </div>
        </div>
        <div>
          <div class="label">Phone</div>
          <div class="value"><?php echo h($order['customer_phone']); ?></div>
        </div>
      </div>
    </div>
    <div class="col col-6">
      <div class="box">
        <h4 class="section-title">Event Details</h4>
        <div>
          <div class="label">Event Date</div>
          <div class="value"><?php echo h($order['event_date']); ?></div>
        </div>
        <div>
          <div class="label">Event Type</div>
          <div class="value"><?php echo h($order['event_type']); ?></div>
        </div>
        <div>
          <div class="label">Delivery Option</div>
          <div class="value">
            <?php echo h($order['delivery_option']); ?>
            <?php if (!empty($order['delivery_location'])): ?>
              — <?php echo h($order['delivery_location']); ?>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="box">
    <h4 class="section-title">Cake Details</h4>
    <table>
      <thead>
        <tr>
          <th style="width:25%;">Item</th>
          <th style="width:20%;">Description</th>
          <th style="width:10%;">Size</th>
          <th style="width:15%;">Flavour</th>
          <th style="width:20%;">Message</th>
          <th class="text-end" style="width:5%;">Qty</th>
          <th class="text-end" style="width:10%;">Price</th>
          <th class="text-end" style="width:10%;">Total</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $total = 0;
        foreach ($items as $it):
          $total += (float)$it['line_total'];
        ?>
        <tr>
          <td>
            <?php
              if (!empty($it['code']) || !empty($it['name'])) {
                  echo h(trim(($it['code'] ?? '') . ' ' . ($it['name'] ?? '')));
              } else {
                  echo 'Cake';
              }
            ?>
          </td>
          <td><?php echo h($it['description']); ?></td>
          <td><?php echo h($it['size']); ?></td>
          <td><?php echo h($it['flavour']); ?></td>
          <td><?php echo h($it['message_on_cake']); ?></td>
          <td class="text-end"><?php echo (int)$it['qty']; ?></td>
          <td class="text-end"><?php echo number_format($it['unit_price'], 2); ?></td>
          <td class="text-end"><?php echo number_format($it['line_total'], 2); ?></td>
        </tr>
        <?php endforeach; ?>
        <?php if (empty($items)): ?>
        <tr>
          <td colspan="8" class="text-center">No items.</td>
        </tr>
        <?php endif; ?>
      </tbody>
    </table>

    <table class="totals">
      <tr>
        <td class="label">Total</td>
        <td class="value">KES <?php echo number_format($order['total_amount'], 2); ?></td>
      </tr>
      <tr>
        <td class="label">Deposit</td>
        <td class="value">KES <?php echo number_format($order['deposit_amount'], 2); ?></td>
      </tr>
      <tr>
        <td class="label">Balance</td>
        <td class="value">KES <?php echo number_format($order['balance_amount'], 2); ?></td>
      </tr>
      <tr>
        <td class="label">Payment Status</td>
        <td class="value"><?php echo h($order['payment_status']); ?></td>
      </tr>
      <tr>
        <td class="label">Order Status</td>
        <td class="value"><?php echo h($order['status']); ?></td>
      </tr>
    </table>
  </div>

  <?php if (!empty($order['notes'])): ?>
    <div class="box">
      <h4 class="section-title">Notes / Design Instructions</h4>
      <div style="white-space: pre-wrap;"><?php echo nl2br(h($order['notes'])); ?></div>
    </div>
  <?php endif; ?>

  <div class="footer">
    <div class="sign-box">
      <div class="label">Customer Approval</div>
      <div class="sign-line"></div>
      <div>Date: ____________</div>
    </div>
    <div class="sign-box" style="text-align:right;">
      <div class="label">For Bakery</div>
      <div class="sign-line" style="margin-left:auto;"></div>
      <div>Date: ____________</div>
    </div>
  </div>
</div>
</body>
</html>
