<?php
require_once __DIR__ . "/../../config/auth.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../includes/helpers.php";
csrf_token();

$page_title = "Cake Order";

$id  = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$row = [];
if ($id) {
    $stmt = $conn->prepare("SELECT * FROM cake_orders WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    if (!$row) $id = 0;
}

// Customers list
$customers = $conn->query("
  SELECT id, code, name, phone 
  FROM customers 
  ORDER BY name
")->fetch_all(MYSQLI_ASSOC);

// Cake products (optional, for pricing & stock)
$products = $conn->query("
  SELECT id, code, name, category, selling_price
  FROM products
  WHERE status = 'Active'
  ORDER BY category, name
")->fetch_all(MYSQLI_ASSOC);

// Existing items
$items = [];
if ($id) {
    $stmt = $conn->prepare("
      SELECT coi.*, p.code, p.name 
      FROM cake_order_items coi
      LEFT JOIN products p ON coi.product_id = p.id
      WHERE coi.cake_order_id = ?
    ");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>
<?php require_once __DIR__ . "/../../includes/layout.php"; ?>
<div class="sb-card mb-3">
  <h5 class="mb-2"><?php echo $id ? "Edit" : "New"; ?> Cake Order</h5>
  <form method="post" action="order_save.php" class="small">
    <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
    <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">

    <div class="row g-2">
      <div class="col-md-3">
        <label class="form-label mb-1">Order Date</label>
        <input type="date" name="order_date" class="form-control form-control-sm"
               value="<?php echo h($row['order_date'] ?? date('Y-m-d')); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Order No</label>
        <input type="text" name="order_no" class="form-control form-control-sm"
               value="<?php echo h($row['order_no'] ?? 'CK-' . date('ymd-His')); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Event Date</label>
        <input type="date" name="event_date" class="form-control form-control-sm"
               value="<?php echo h($row['event_date'] ?? date('Y-m-d')); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Event Type</label>
        <input type="text" name="event_type" class="form-control form-control-sm"
               value="<?php echo h($row['event_type'] ?? 'Birthday'); ?>">
      </div>
    </div>

    <div class="row g-2 mt-2">
      <div class="col-md-4">
        <label class="form-label mb-1">Customer (existing)</label>
        <select name="customer_id" class="form-select form-select-sm">
          <option value="">-- walk-in / manual --</option>
          <?php foreach($customers as $c): ?>
            <option value="<?php echo $c['id']; ?>"
              <?php echo ($row['customer_id'] ?? 0) == $c['id'] ? 'selected' : ''; ?>>
              <?php echo h($c['code'] . ' — ' . $c['name']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label mb-1">Customer Name (print on order)</label>
        <input type="text" name="customer_name" class="form-control form-control-sm"
               value="<?php echo h($row['customer_name'] ?? ''); ?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label mb-1">Customer Phone</label>
        <input type="text" name="customer_phone" class="form-control form-control-sm"
               value="<?php echo h($row['customer_phone'] ?? ''); ?>">
      </div>
    </div>

    <div class="row g-2 mt-2">
      <div class="col-md-3">
        <label class="form-label mb-1">Status</label>
        <select name="status" class="form-select form-select-sm">
          <?php
          $status = $row['status'] ?? 'Enquiry';
          $statuses = ['Enquiry','Confirmed','In Production','Ready','Delivered','Cancelled'];
          foreach($statuses as $st):
          ?>
            <option value="<?php echo $st; ?>" <?php echo $status === $st ? 'selected' : ''; ?>>
              <?php echo $st; ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Delivery Option</label>
        <select name="delivery_option" class="form-select form-select-sm">
          <?php
          $delOpt = $row['delivery_option'] ?? 'Pickup';
          $opts = ['Pickup','Delivery'];
          foreach($opts as $op):
          ?>
            <option value="<?php echo $op; ?>" <?php echo $delOpt === $op ? 'selected' : ''; ?>>
              <?php echo $op; ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label mb-1">Delivery Location / Venue</label>
        <input type="text" name="delivery_location" class="form-control form-control-sm"
               value="<?php echo h($row['delivery_location'] ?? ''); ?>">
      </div>
    </div>

    <div class="row g-2 mt-2">
      <div class="col-md-3">
        <label class="form-label mb-1">Deposit (from POS)</label>
        <input type="text" class="form-control form-control-sm text-end"
               value="<?php echo number_format($row['deposit_amount'] ?? 0, 2); ?>" readonly>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Balance (auto)</label>
        <input type="text" class="form-control form-control-sm text-end"
               value="<?php echo number_format($row['balance_amount'] ?? 0, 2); ?>" readonly>
      </div>
      <div class="col-md-6">
        <label class="form-label mb-1">Notes (design, colours, reference photos)</label>
        <input type="text" name="notes" class="form-control form-control-sm"
               value="<?php echo h($row['notes'] ?? ''); ?>">
      </div>
    </div>

    <hr class="border-secondary my-3">

    <h6 class="text-uppercase text-muted small mb-2">Cake Items</h6>

    <div class="table-responsive small mb-2">
      <table class="table table-dark table-borderless align-middle mb-0">
        <thead class="text-muted text-uppercase small">
          <tr>
            <th style="width:25%;">Product</th>
            <th style="width:25%;">Description</th>
            <th style="width:10%;">Size</th>
            <th style="width:15%;">Flavour</th>
            <th style="width:15%;">Message</th>
            <th class="text-end" style="width:5%;">Qty</th>
            <th class="text-end" style="width:10%;">Unit Price</th>
          </tr>
        </thead>
        <tbody>
          <?php
          $lines = [];
          foreach ($items as $it) {
              $lines[] = [
                  'product_id' => $it['product_id'],
                  'description'=> $it['description'],
                  'size'       => $it['size'],
                  'flavour'    => $it['flavour'],
                  'message_on_cake' => $it['message_on_cake'],
                  'qty'        => $it['qty'],
                  'unit_price' => $it['unit_price'],
              ];
          }
          $minRows = 5;
          while (count($lines) < $minRows) {
              $lines[] = [
                  'product_id' => '',
                  'description'=> '',
                  'size'       => '',
                  'flavour'    => '',
                  'message_on_cake' => '',
                  'qty'        => '',
                  'unit_price' => '',
              ];
          }
          foreach ($lines as $ln):
          ?>
          <tr>
            <td>
              <select name="product_id[]" class="form-select form-select-sm cake-product-select">
                <option value="">-- select cake --</option>
                <?php foreach($products as $p): ?>
                  <option value="<?php echo $p['id']; ?>"
                    data-price="<?php echo h($p['selling_price']); ?>"
                    <?php echo (string)$ln['product_id'] === (string)$p['id'] ? 'selected' : ''; ?>>
                    <?php echo h($p['code'] . ' — ' . $p['name']); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </td>
            <td>
              <input type="text" name="description[]" class="form-control form-control-sm"
                     value="<?php echo h($ln['description']); ?>"
                     placeholder="e.g. 3-tier white & gold">
            </td>
            <td>
              <input type="text" name="size[]" class="form-control form-control-sm"
                     value="<?php echo h($ln['size']); ?>"
                     placeholder="e.g. 3-tier / 3kg">
            </td>
            <td>
              <input type="text" name="flavour[]" class="form-control form-control-sm"
                     value="<?php echo h($ln['flavour']); ?>"
                     placeholder="e.g. Vanilla">
            </td>
            <td>
              <input type="text" name="message_on_cake[]" class="form-control form-control-sm"
                     value="<?php echo h($ln['message_on_cake']); ?>"
                     placeholder="e.g. Happy Birthday Allan">
            </td>
            <td class="text-end">
              <input type="number" name="qty[]" class="form-control form-control-sm text-end cake-qty"
                     value="<?php echo h($ln['qty']); ?>" min="0" step="1">
            </td>
            <td class="text-end">
              <input type="number" step="0.01" name="unit_price[]"
                     class="form-control form-control-sm text-end cake-price"
                     value="<?php echo h($ln['unit_price']); ?>">
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <!-- Live totals preview -->
    <div class="row g-2 mt-2">
      <div class="col-md-3">
        <label class="form-label mb-1">Estimated Total (auto)</label>
        <input type="text" id="est_total" class="form-control form-control-sm text-end" value="0.00" readonly>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1">Estimated Balance (Total - paid)</label>
        <input type="text" id="est_balance" class="form-control form-control-sm text-end" value="0.00" readonly>
      </div>
      <div class="col-md-6 d-flex align-items-end">
        <p class="small text-muted mb-0">
          Payments must be received at the POS counter. This is just a quick estimate.
        </p>
      </div>
    </div>

    <div class="d-flex justify-content-between align-items-center mt-3">
      <a href="orders_list.php" class="btn btn-sm btn-outline-light rounded-pill">
        <i class="fa-solid fa-arrow-left-long me-1"></i> Back
      </a>
      <button type="submit" class="btn btn-sm btn-primary rounded-pill"
              style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
        <i class="fa-solid fa-floppy-disk me-1"></i> Save Order
      </button>
    </div>
  </form>
</div>

<script>
(function() {
  function recalcTotals() {
    let total = 0;

    document.querySelectorAll('input[name="qty[]"]').forEach(function(qtyEl) {
      const row = qtyEl.closest('tr');
      if (!row) return;

      const priceEl = row.querySelector('input[name="unit_price[]"]');
      const qty   = parseFloat(qtyEl.value)   || 0;
      const price = parseFloat(priceEl ? priceEl.value : 0) || 0;
      total += (qty * price);
    });

    // Paid so far = deposit_amount stored in DB
    const paid = <?php echo (float)($row['deposit_amount'] ?? 0); ?>;

    const estTotalEl   = document.getElementById('est_total');
    const estBalanceEl = document.getElementById('est_balance');

    if (estTotalEl)   estTotalEl.value   = total.toFixed(2);
    if (estBalanceEl) estBalanceEl.value = (total - paid).toFixed(2);
  }

  // Auto-fill unit price + default qty=1 when product selected
  document.querySelectorAll('.cake-product-select').forEach(function(sel) {
    sel.addEventListener('change', function() {
      const opt = this.selectedOptions[0];
      const row = this.closest('tr');
      if (!row || !opt) return;

      const priceInput = row.querySelector('.cake-price');
      const qtyInput   = row.querySelector('.cake-qty');

      const price = parseFloat(opt.dataset.price || 0);

      if (priceInput && (!priceInput.value || parseFloat(priceInput.value) === 0)) {
        priceInput.value = price.toFixed(2);
      }
      if (qtyInput && (!qtyInput.value || parseFloat(qtyInput.value) === 0)) {
        qtyInput.value = 1;
      }
      recalcTotals();
    });
  });

  // Recalculate when qty or price changes
  document.querySelectorAll('.cake-qty, .cake-price').forEach(function(inp) {
    inp.addEventListener('input', recalcTotals);
  });

  // Initial calc
  recalcTotals();
})();
</script>

<?php require_once __DIR__ . "/../../includes/footer.php"; ?>
