<?php
require_once __DIR__ . "/config/auth.php";
require_once __DIR__ . "/config/db.php";

$page_title = "Bakery Control Center";
require_once __DIR__ . "/includes/layout.php";

/**
 * 🔢 Quick demo metrics – replace with real SQL later
 * ----------------------------------------------------------------
 * Example:
 *   $today = date('Y-m-d');
 *   $stmt  = $conn->prepare("SELECT COALESCE(SUM(actual_qty),0) FROM production_batches WHERE production_date = ?");
 *   $stmt->bind_param('s', $today);
 *   $stmt->execute();
 *   $stmt->bind_result($today_loaves);
 *   $stmt->fetch();
 *   $stmt->close();
 */

$today_loaves = 3500;
$returns_pct  = 0.9;
$routes       = 16;
$sales        = 94580;

// 🧁 Demo data for Oven Batches — replace with DB rows later
$oven_batches = [
    [
        'batch'    => 'BD-001',
        'product'  => '800g White Bread',
        'planned'  => 1400,
        'actual'   => 1392,
        'variance' => -8,
        'oven'     => 'Deck 1',
    ],
    [
        'batch'    => 'BD-002',
        'product'  => '600g Brown Bread',
        'planned'  => 1000,
        'actual'   => 1012,
        'variance' => 12,
        'oven'     => 'Deck 2',
    ],
    [
        'batch'    => 'CK-011',
        'product'  => 'Assorted Cakes & Cupcakes',
        'planned'  => 180,
        'actual'   => 178,
        'variance' => -2,
        'oven'     => 'Conveyor',
    ],
];

// 🚚 Demo data for Routes & Loading — replace with DB rows later
$routes_loading = [
    [
        'code'     => 'R1 — CBD / Estates',
        'meta'     => 'Bike • 18 stops • 420 loaves',
        'status'   => 'Out',
        'badge'    => 'text-bg-success-subtle border border-success-subtle',
        'icon'     => 'fa-circle-play',
    ],
    [
        'code'     => 'V3 — Supermarkets',
        'meta'     => 'Van • 9 stops • 760 loaves',
        'status'   => 'Loading',
        'badge'    => 'text-bg-warning-subtle border border-warning-subtle',
        'icon'     => 'fa-circle-half-stroke',
    ],
    [
        'code'     => 'B7 — Rural Routes',
        'meta'     => 'Bike • 14 stops • 390 loaves',
        'status'   => 'Closed',
        'badge'    => 'text-bg-secondary-subtle border border-secondary-subtle',
        'icon'     => 'fa-circle-check',
    ],
];
?>

<div class="row g-3 mb-3">
  <div class="col-md-3 col-6">
    <div class="sb-card h-100">
      <h5>Today’s Loaves</h5>
      <div class="d-flex justify-content-between align-items-end">
        <span class="sb-metric">
          <?php echo number_format($today_loaves); ?>
        </span>
        <span class="sb-chip">
          <i class="fa-solid fa-arrow-trend-up me-1"></i> +4.2%
        </span>
      </div>
      <div class="small text-muted mt-1">
        800g • 600g • 400g • 200g — all lines
      </div>
    </div>
  </div>

  <div class="col-md-3 col-6">
    <div class="sb-card h-100">
      <h5>Market Returns</h5>
      <div class="d-flex justify-content-between align-items-end">
        <span class="sb-metric">
          <?php echo number_format($returns_pct, 1); ?>%
        </span>
        <span class="badge rounded-pill text-bg-success-subtle border border-success-subtle">
          <i class="fa-solid fa-circle-check me-1"></i> Healthy
        </span>
      </div>
      <div class="small text-muted mt-1">
        Target &lt; 1.2%
      </div>
    </div>
  </div>

  <div class="col-md-3 col-6">
    <div class="sb-card h-100">
      <h5>Active Routes</h5>
      <div class="d-flex justify-content-between align-items-end">
        <span class="sb-metric">
          <?php echo number_format($routes); ?>
        </span>
        <span class="badge rounded-pill text-bg-secondary-subtle border border-secondary-subtle">
          <i class="fa-solid fa-motorcycle me-1"></i> Bikes &amp; Vans
        </span>
      </div>
      <div class="small text-muted mt-1">
        Urban • Peri-urban • Rural mix
      </div>
    </div>
  </div>

  <div class="col-md-3 col-6">
    <div class="sb-card h-100">
      <h5>Today’s Sales</h5>
      <div class="d-flex justify-content-between align-items-end">
        <span class="sb-metric">
          KES <?php echo number_format($sales, 0); ?>
        </span>
        <span class="sb-chip">
          <i class="fa-solid fa-wallet me-1"></i> Cash + Mpesa
        </span>
      </div>
      <div class="small text-muted mt-1">
        Counter + Van + Invoices
      </div>
    </div>
  </div>
</div>

<div class="row g-3">
  <div class="col-lg-7">
    <div class="sb-card h-100">
      <h5>Oven Batches — Today</h5>
      <p class="small text-muted mb-2">
        Snapshot of bread &amp; pastry batches from production.
      </p>
      <div class="table-responsive small">
        <table class="table table-dark table-borderless align-middle mb-0">
          <thead class="text-muted text-uppercase small">
            <tr>
              <th>Batch</th>
              <th>Product</th>
              <th class="text-end">Planned</th>
              <th class="text-end">Actual</th>
              <th class="text-end">Variance</th>
              <th>Oven</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($oven_batches as $b): ?>
              <?php
                $variance = (int)$b['variance'];
                $variance_class = $variance < 0
                    ? 'text-warning'
                    : ($variance > 0 ? 'text-success' : 'text-muted');
              ?>
              <tr>
                <td><?php echo htmlspecialchars($b['batch']); ?></td>
                <td><?php echo htmlspecialchars($b['product']); ?></td>
                <td class="text-end"><?php echo number_format($b['planned']); ?></td>
                <td class="text-end"><?php echo number_format($b['actual']); ?></td>
                <td class="text-end <?php echo $variance_class; ?>">
                  <?php echo ($variance > 0 ? '+' : '') . $variance; ?>
                </td>
                <td><?php echo htmlspecialchars($b['oven']); ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <div class="col-lg-5">
    <div class="sb-card h-100">
      <h5>Routes &amp; Loading</h5>
      <p class="small text-muted mb-2">
        Live impression of today’s dispatch.
      </p>
      <div class="list-group list-group-flush small">
        <?php foreach ($routes_loading as $r): ?>
          <div class="list-group-item bg-transparent text-white border-0 px-0 d-flex justify-content-between align-items-center">
            <div>
              <div class="fw-semibold">
                <?php echo htmlspecialchars($r['code']); ?>
              </div>
              <div class="text-muted">
                <?php echo htmlspecialchars($r['meta']); ?>
              </div>
            </div>
            <span class="badge rounded-pill <?php echo htmlspecialchars($r['badge']); ?>">
              <i class="fa-solid <?php echo htmlspecialchars($r['icon']); ?> me-1"></i>
              <?php echo htmlspecialchars($r['status']); ?>
            </span>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
