<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . "/helpers.php";
?>
<!doctype html>
<html lang="en" data-bs-theme="dark">
<head>
  <meta charset="utf-8">
  <title><?php echo isset($page_title) ? h($page_title) . " | SmartBake360" : "SmartBake360"; ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
  <style>
    :root {
      --sb-primary: #f97316;
      --sb-primary-dark: #ea580c;
      --sb-bg: #020617;
      --sb-card-bg: #020617;
      --sb-outline: rgba(148,163,184,0.35);
      --sb-radius-lg: 18px;
    }
    body {
      min-height: 100vh;
      background:
        radial-gradient(circle at top left, rgba(248,250,252,0.06), transparent 55%),
        radial-gradient(circle at bottom right, rgba(248,250,252,0.03), transparent 55%),
        #020617;
      color: #e5e7eb;
      font-family: system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",sans-serif;
    }
    .sb-shell {
      display: flex;
      min-height: 100vh;
    }
    .sb-sidebar {
      width: 250px;
      background: linear-gradient(180deg,#020617,#020617 60%,#020617);
      border-right: 1px solid rgba(148,163,184,0.25);
      position: sticky;
      top: 0;
      height: 100vh;
      padding: 1rem .75rem;
    }
    .sb-logo {
      font-weight: 800;
      font-size: 1.35rem;
      letter-spacing: .09em;
      text-transform: uppercase;
      color: #f9fafb;
    }
    .sb-logo span {
      color: var(--sb-primary);
    }
    .sb-tagline {
      font-size: .72rem;
      text-transform: uppercase;
      letter-spacing: .16em;
      color: #9ca3af;
    }
    .sb-nav {
      margin-top: 1.4rem;
    }
    .sb-nav a {
      display: flex;
      align-items: center;
      gap: .7rem;
      padding: .6rem .8rem;
      border-radius: 999px;
      color: #9ca3af;
      text-decoration: none;
      font-size: .88rem;
      margin-bottom: .12rem;
      transition: all .16s ease;
    }
    .sb-nav a i {
      width: 1.25rem;
      text-align: center;
      font-size: .95rem;
    }
    .sb-nav a:hover {
      background: #020617;
      color: #e5e7eb;
      box-shadow: 0 0 0 1px rgba(148,163,184,0.45);
    }
    .sb-nav a.active {
      background: #0b1120;
      color: #f9fafb;
      box-shadow: 0 0 0 1px rgba(248,250,252,0.06),0 12px 30px rgba(15,23,42,0.7);
    }

    /* ▼ upgraded section label for collapsible groups */
    .sb-section-label {
      font-size:.7rem;
      text-transform:uppercase;
      letter-spacing:.16em;
      color:#6b7280;
      padding:.35rem .85rem .2rem;
      margin-top:1rem;
      display:flex;
      align-items:center;
      justify-content:space-between;
      cursor:pointer;
      user-select:none;
      border-radius:999px;
      transition:background .16s ease,color .16s ease;
    }
    .sb-section-label span {
      display:inline-flex;
      align-items:center;
      gap:.3rem;
    }
    .sb-section-label:hover {
      background:rgba(15,23,42,0.9);
      color:#9ca3af;
    }
    .sb-section-chevron {
      font-size:.6rem;
      transition:transform .18s ease;
    }
    .sb-section-label[aria-expanded="true"] .sb-section-chevron {
      transform:rotate(90deg);
    }

    /* ▼ collapsible body */
    .sb-group-body {
      overflow:hidden;
      transition:max-height .22s ease,opacity .18s ease,margin .16s ease;
      max-height:700px;
      opacity:1;
    }
    .sb-group-body.collapsed {
      max-height:0;
      opacity:0;
      margin-top:0;
      pointer-events:none;
    }

    .sb-main {
      flex: 1;
      display: flex;
      flex-direction: column;
      padding: 1.25rem 1.6rem;
      gap: 1rem;
    }
    .sb-topbar {
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap:.75rem;
    }
    .sb-pill {
      display:inline-flex;
      align-items:center;
      gap:.4rem;
      padding:.2rem .8rem;
      border-radius:999px;
      font-size:.72rem;
      border:1px solid rgba(148,163,184,0.4);
      background:rgba(15,23,42,0.9);
      color:#9ca3af;
      text-transform:uppercase;
      letter-spacing:.12em;
    }
    .sb-main-inner {
      background: radial-gradient(circle at top left, rgba(248,250,252,0.03), transparent 55%);
      border-radius: 22px;
      padding: 1.25rem 1.35rem 1rem;
      border: 1px solid rgba(148,163,184,0.28);
      box-shadow: 0 28px 70px rgba(15,23,42,0.9);
    }
    .sb-card {
      background: rgba(15,23,42,0.96);
      border-radius: 16px;
      border: 1px solid rgba(148,163,184,0.3);
      padding: .9rem 1rem;
      color: #e5e7eb;
      box-shadow: 0 18px 40px rgba(15,23,42,0.8);
    }
    .sb-card h5 {
      font-size:.9rem;
      text-transform:uppercase;
      letter-spacing:.16em;
      color:#9ca3af;
      margin-bottom:.35rem;
    }
    .sb-metric {
      font-size:1.5rem;
      font-weight:700;
      color:#f9fafb;
    }
    .sb-chip {
      font-size:.75rem;
      padding:.15rem .6rem;
      border-radius:999px;
      background:rgba(34,197,94,0.14);
      color:#bbf7d0;
      border:1px solid rgba(34,197,94,0.5);
    }
    .sb-user {
      display:flex;
      align-items:center;
      gap:.6rem;
      padding:.3rem .8rem;
      border-radius:999px;
      border:1px solid rgba(148,163,184,0.35);
      background:rgba(15,23,42,0.9);
    }
    .sb-avatar {
      width:28px;
      height:28px;
      border-radius:999px;
      background:linear-gradient(135deg,#f97316,#fb923c);
      display:flex;
      align-items:center;
      justify-content:center;
      color:#020617;
      font-size:.8rem;
      font-weight:700;
    }
    .sb-badge-soft {
      border-radius:999px;
      border:1px solid rgba(148,163,184,0.5);
      padding:.1rem .55rem;
      font-size:.72rem;
      color:#e5e7eb;
    }
    .sb-footer {
      font-size:.72rem;
      color:#9ca3af;
      margin-top:.4rem;
      text-align:right;
    }
    @media (max-width:991.98px) {
      .sb-shell { flex-direction:column; }
      .sb-sidebar { display:none; }
      .sb-main { padding:1rem; }
    }
  </style>
</head>
<body>
<div class="sb-shell">
  <aside class="sb-sidebar d-none d-lg-flex flex-column justify-content-between">
    <div>
      <div class="px-2 mb-3">
        <div class="sb-logo mb-1"><span>Smart</span>Bake</div>
        <div class="sb-tagline">Bakery ERP • Production • Routes</div>
      </div>
      <nav class="sb-nav" id="sb-nav">
        <!-- Dashboard -->
        <a href="/smartbake360/index.php">
          <i class="fa-solid fa-chart-line"></i><span>Dashboard</span>
        </a>

        <!-- Operations -->
        <div class="sb-section-label"
             data-sb-collapse-target="#sb-group-operations"
             aria-expanded="true">
          <span>Operations</span>
          <i class="fa-solid fa-chevron-right sb-section-chevron"></i>
        </div>
        <div class="sb-group-body" id="sb-group-operations">
          <a href="/smartbake360/modules/production/batches_list.php">
            <i class="fa-solid fa-fire-burner"></i><span>Production Batches</span>
          </a>
          <a href="/smartbake360/modules/dispatch/loadings_list.php">
            <i class="fa-solid fa-truck-ramp-box"></i><span>Dispatch &amp; Loading</span>
          </a>
          <a href="/smartbake360/modules/vansales/sales_list.php">
            <i class="fa-solid fa-motorcycle"></i><span>Van Sales</span>
          </a>
          <a href="/smartbake360/modules/pos/counter.php">
            <i class="fa-solid fa-cash-register"></i><span>Counter POS</span>
          </a>
          <a href="/smartbake360/modules/pos/sales_list.php">
            <i class="fa-solid fa-receipt"></i><span>POS Sales</span>
          </a>
          <a href="/smartbake360/modules/cakes/orders_list.php">
            <i class="fa-solid fa-cake-candles"></i><span>Cake Orders</span>
          </a>
        </div>

        <!-- Inventory & Master -->
        <div class="sb-section-label"
             data-sb-collapse-target="#sb-group-inventory"
             aria-expanded="false">
          <span>Inventory &amp; Master</span>
          <i class="fa-solid fa-chevron-right sb-section-chevron"></i>
        </div>
        <div class="sb-group-body collapsed" id="sb-group-inventory">
          <a href="/smartbake360/modules/master/products_list.php">
            <i class="fa-solid fa-bread-slice"></i><span>Products (SKUs)</span>
          </a>
          <a href="/smartbake360/modules/master/fg_stock.php">
            <i class="fa-solid fa-boxes-stacked"></i><span>Finished Goods Stock</span>
          </a>
          <a href="/smartbake360/modules/master/raw_materials_list.php">
            <i class="fa-solid fa-wheat-awn"></i><span>Raw Materials</span>
          </a>
          <a href="/smartbake360/modules/recipes/recipes_list.php">
            <i class="fa-solid fa-list-check"></i><span>Recipes &amp; BOM</span>
          </a>
          <a href="/smartbake360/modules/recipes/costing.php">
            <i class="fa-solid fa-scale-balanced"></i><span>Costing</span>
          </a>
          <a href="/smartbake360/modules/master/customers_list.php">
            <i class="fa-solid fa-store"></i><span>Customers</span>
          </a>
          <a href="/smartbake360/modules/master/suppliers_list.php">
            <i class="fa-solid fa-truck-field"></i><span>Suppliers</span>
          </a>
          <a href="/smartbake360/modules/master/branches_list.php">
            <i class="fa-solid fa-location-dot"></i><span>Branches</span>
          </a>
          <a href="/smartbake360/modules/master/vehicles_list.php">
            <i class="fa-solid fa-truck"></i><span>Vehicles</span>
          </a>
          <a href="/smartbake360/modules/vansales/routes_list.php">
            <i class="fa-solid fa-motorcycle"></i><span>Routes &amp; Van Sales</span>
          </a>
          <a href="/smartbake360/modules/master/riders_list.php">
            <i class="fa-solid fa-id-card-clip"></i><span>Riders &amp; Sales</span>
          </a>
        </div>

        <!-- Finance -->
        <div class="sb-section-label"
             data-sb-collapse-target="#sb-group-finance"
             aria-expanded="false">
          <span>Finance</span>
          <i class="fa-solid fa-chevron-right sb-section-chevron"></i>
        </div>
        <div class="sb-group-body collapsed" id="sb-group-finance">
          <a href="/smartbake360/modules/finance/invoices_list.php">
            <i class="fa-solid fa-file-invoice-dollar"></i><span>Invoices &amp; AR</span>
          </a>
          <a href="/smartbake360/modules/finance/expenses_list.php">
            <i class="fa-solid fa-wallet"></i><span>Expenses &amp; Cash</span>
          </a>
        </div>
      </nav>

    </div>
    <div class="px-2">
      <div class="sb-user mb-2">
        <div class="sb-avatar"><?php echo strtoupper(substr($_SESSION['username'] ?? 'SB',0,2)); ?></div>
        <div class="d-flex flex-column">
          <span class="small fw-semibold"><?php echo h($_SESSION['username'] ?? 'Bake Manager'); ?></span>
          <span class="text-muted" style="font-size:.7rem;">SmartBake360 • Gustolix</span>
        </div>
      </div>
      <div class="d-flex justify-content-between align-items-center">
        <span class="sb-badge-soft"><i class="fa-solid fa-circle text-success me-1" style="font-size:.5rem;"></i> Live</span>
        <a href="/smartbake360/auth/logout.php" class="btn btn-sm btn-outline-light rounded-pill px-2 py-1">
          <i class="fa-solid fa-right-from-bracket me-1"></i> Logout
        </a>
      </div>
    </div>
  </aside>
  <main class="sb-main">
    <div class="sb-topbar">
      <div>
        <div class="sb-pill mb-1">
          <i class="fa-solid fa-bread-slice"></i>
          <span>SmartBake360 — All-round bakery ERP</span>
        </div>
        <h1 class="h4 text-white mb-0">
          <?php echo h($page_title ?? 'Dashboard'); ?>
        </h1>
      </div>
      <div class="d-flex align-items-center gap-2">
        <button class="btn btn-sm btn-outline-light rounded-pill px-3 d-none d-md-inline-flex">
          <i class="fa-regular fa-bell me-1"></i> Alerts
        </button>
        <a href="/smartbake360/modules/production/batch_form.php" class="btn btn-sm btn-primary rounded-pill px-3" style="background:var(--sb-primary);border-color:var(--sb-primary-dark);">
          <i class="fa-solid fa-plus me-1"></i> New batch
        </a>
      </div>
    </div>
    <div class="sb-main-inner">
      <?php if ($m = flash_get('success')): ?>
        <div class="alert alert-success py-2 small rounded-pill mb-2"><?php echo h($m); ?></div>
      <?php endif; ?>
      <?php if ($m = flash_get('error')): ?>
        <div class="alert alert-danger py-2 small rounded-pill mb-2"><?php echo h($m); ?></div>
      <?php endif; ?>
      <!-- page content continues… -->
