<?php
if (!function_exists('h')) {
    function h($v) {
        return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
    }
}
if (!function_exists('redirect')) {
    function redirect($url) {
        header("Location: " . $url);
        exit;
    }
}
if (!function_exists('csrf_token')) {
    function csrf_token() {
        if (session_status() === PHP_SESSION_NONE) session_start();
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf_token'];
    }
}
if (!function_exists('csrf_check')) {
    function csrf_check() {
        if (session_status() === PHP_SESSION_NONE) session_start();
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $t = $_POST['csrf_token'] ?? '';
            if (!$t || !hash_equals($_SESSION['csrf_token'] ?? '', $t)) {
                die("Security check failed (CSRF).");
            }
        }
    }
}
if (!function_exists('flash_set')) {
    function flash_set($key, $msg) {
        if (session_status() === PHP_SESSION_NONE) session_start();
        $_SESSION['flash'][$key] = $msg;
    }
}
if (!function_exists('flash_get')) {
    function flash_get($key) {
        if (session_status() === PHP_SESSION_NONE) session_start();
        if (isset($_SESSION['flash'][$key])) {
            $m = $_SESSION['flash'][$key];
            unset($_SESSION['flash'][$key]);
            return $m;
        }
        return null;
    }
}
?>
