<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
if (!has_role($u, ['Admin','Owner'])) { http_response_code(403); exit('Forbidden'); }
csrf_check();
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim((string)($_POST['name'] ?? ''));
  $email= trim((string)($_POST['email'] ?? ''));
  $role = (string)($_POST['role'] ?? 'Cashier');
  $pass = (string)($_POST['password'] ?? '');
  if ($name && $email && $pass) {
    $hash = password_hash($pass, PASSWORD_DEFAULT);
    $pdo->prepare("INSERT INTO users(name,email,role,password_hash,is_active,created_at) VALUES(?,?,?,?,1,NOW())")
        ->execute([$name,$email,$role,$hash]);
    start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'User created.'];
    header('Location: ' . url('settings/users.php')); exit;
  } else $err='Fill name, email and password.';
}

$rows = $pdo->query("SELECT id,name,email,role,is_active,created_at FROM users ORDER BY id DESC")->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="fw-semibold">Users</div>
  <div class="muted">Roles: Admin, Owner, Manager, Production, SalesRep, Cashier, Accountant, Auditor</div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>
<?php if (!empty($err)): ?><div class="alert alert-danger"><?= esc($err) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-12 col-lg-5">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Add User</div>
      <form method="post" class="row g-2">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-12"><input class="form-control" name="name" placeholder="Full name" required></div>
        <div class="col-12"><input class="form-control" name="email" placeholder="email@example.com" required></div>
        <div class="col-12">
          <select class="form-select" name="role">
            <?php foreach(['Admin','Owner','Manager','Production','SalesRep','Cashier','Accountant','Auditor'] as $r): ?>
              <option><?= esc($r) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-12"><input class="form-control" name="password" type="password" placeholder="Temp password" required></div>
        <div class="col-12"><button class="btn btn-primary w-100">Create</button></div>
      </form>
    </div>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Existing Users</div>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Name</th><th>Email</th><th>Role</th><th>Active</th></tr></thead>
          <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?= esc($r['name']) ?></td>
                <td><?= esc($r['email']) ?></td>
                <td><?= esc($r['role']) ?></td>
                <td><?= (int)$r['is_active']? 'Yes':'No' ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="small muted">Password reset module can be added in Phase 1.1.</div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
