<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim((string)($_POST['name'] ?? ''));
  $desc = trim((string)($_POST['description'] ?? ''));
  if ($name) {
    $pdo->prepare("INSERT INTO routes(name, description, created_at) VALUES(?,?,NOW())")->execute([$name, $desc ?: null]);
    start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Route saved.'];
    header('Location: ' . url('settings/routes.php')); exit;
  } else $err='Name required.';
}

$rows = $pdo->query("SELECT * FROM routes ORDER BY name")->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="fw-semibold">Routes</div>
  <div class="muted">Define distribution routes (e.g. Eldoret CBD, Nandi Hills, Kapseret…)</div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>
<?php if (!empty($err)): ?><div class="alert alert-danger"><?= esc($err) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-12 col-lg-5">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Add Route</div>
      <form method="post" class="row g-2">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-12"><input class="form-control" name="name" placeholder="Route name" required></div>
        <div class="col-12"><input class="form-control" name="description" placeholder="Towns/areas"></div>
        <div class="col-12"><button class="btn btn-primary w-100">Save</button></div>
      </form>
    </div>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card p-3">
      <div class="fw-semibold mb-2">List</div>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Name</th><th>Description</th></tr></thead>
          <tbody>
            <?php foreach($rows as $r): ?>
              <tr><td><?= esc($r['name']) ?></td><td><?= esc($r['description']) ?></td></tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
