<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim((string)($_POST['name'] ?? ''));
  $phone = kenya_phone_normalize(trim((string)($_POST['phone'] ?? '')));
  $limit = (float)($_POST['credit_limit'] ?? 0);
  if ($name) {
    $pdo->prepare("INSERT INTO customers(name, phone, credit_limit, balance, created_at) VALUES(?,?,?,?,NOW())")
        ->execute([$name, $phone ?: null, $limit, 0]);
    start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Customer saved.'];
    header('Location: ' . url('settings/customers.php')); exit;
  } else $err='Name required.';
}

$rows = $pdo->query("SELECT * FROM customers ORDER BY name")->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="fw-semibold">Customers</div>
  <div class="muted">Retail walk-ins (optional) + shop customers for credit</div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>
<?php if (!empty($err)): ?><div class="alert alert-danger"><?= esc($err) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-12 col-lg-5">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Add Customer</div>
      <form method="post" class="row g-2">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-12"><input class="form-control" name="name" placeholder="Customer / Shop name" required></div>
        <div class="col-12"><input class="form-control" name="phone" placeholder="+2547xxxxxxxx"></div>
        <div class="col-12"><input class="form-control" name="credit_limit" type="number" step="0.01" placeholder="Credit limit (KES)" value="0"></div>
        <div class="col-12"><button class="btn btn-primary w-100">Save</button></div>
      </form>
    </div>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card p-3">
      <div class="fw-semibold mb-2">List</div>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Name</th><th>Phone</th><th class="text-end">Limit</th><th class="text-end">Balance</th></tr></thead>
          <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?= esc($r['name']) ?></td>
                <td><?= esc($r['phone']) ?></td>
                <td class="text-end"><?= esc(money($r['credit_limit'])) ?></td>
                <td class="text-end"><?= esc(money($r['balance'])) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
