<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

$pid = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM products WHERE id=?");
$stmt->execute([$pid]);
$product = $stmt->fetch();
if (!$product) { http_response_code(404); exit('Product not found'); }

$items = $pdo->query("SELECT id,name,uom FROM items ORDER BY name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pdo->prepare("DELETE FROM recipes WHERE product_id=?")->execute([$pid]);
  $lines = (array)($_POST['lines'] ?? []);
  $stmtI = $pdo->prepare("INSERT INTO recipes(product_id, item_id, qty_per_unit) VALUES(?,?,?)");
  foreach($lines as $ln){
    $item_id = (int)($ln['item_id'] ?? 0);
    $qty = (float)($ln['qty_per_unit'] ?? 0);
    if ($item_id>0 && $qty>0) $stmtI->execute([$pid, $item_id, $qty]);
  }
  start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Recipe saved.'];
  header('Location: ' . url('production/products.php'));
  exit;
}

$recipe = $pdo->prepare("SELECT r.*, i.name, i.uom FROM recipes r JOIN items i ON i.id=r.item_id WHERE r.product_id=? ORDER BY i.name");
$recipe->execute([$pid]);
$rows = $recipe->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Recipe (BOM): <?= esc($product['name']) ?></div>
      <div class="muted">Qty per 1 <?= esc($product['uom']) ?> produced</div>
    </div>
    <a class="btn btn-outline-light" href="<?= esc(url('production/products.php')) ?>">Back</a>
  </div>

  <form method="post" class="mt-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div id="lines"></div>
    <button type="button" class="btn btn-outline-light" onclick="addLine()">+ Add Ingredient</button>
    <button class="btn btn-primary ms-2">Save Recipe</button>
  </form>
</div>

<script>
const items = <?= json.dumps(array_map(fn($i)=>['id'=>(int)$i['id'],'name'=>$i['name'],'uom'=>$i['uom']], $items)) ?>;
const existing = <?= json.dumps(array_map(fn($r)=>['item_id'=>(int)$r['item_id'],'qty'=>(float)$r['qty_per_unit']], $rows)) ?>;

function addLine(selId='', qty=''){
  const wrap = document.getElementById('lines');
  const idx = wrap.children.length;
  const div = document.createElement('div');
  div.className = 'row g-2 mb-2';
  div.innerHTML = `
    <div class="col-md-8">
      <select class="form-select" name="lines[${idx}][item_id]">
        <option value="">Select item…</option>
        ${items.map(i=>`<option value="${i.id}" ${String(i.id)===String(selId)?'selected':''}>${i.name} (${i.uom})</option>`).join('')}
      </select>
    </div>
    <div class="col-md-4">
      <input class="form-control" name="lines[${idx}][qty_per_unit]" type="number" step="0.0001" placeholder="Qty per unit" value="${qty}">
    </div>`;
  wrap.appendChild(div);
}

if (existing.length){
  existing.forEach(e=>addLine(e.item_id, e.qty));
} else {
  addLine();
}
</script>
<?php include __DIR__ . '/../_footer.php'; ?>
