<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
$pdo = db();

$products = $pdo->query("SELECT p.*, COALESCE(s.on_hand,0) on_hand
                         FROM products p
                         LEFT JOIN (SELECT product_id, SUM(qty_in-qty_out) on_hand FROM finished_moves GROUP BY product_id) s ON s.product_id=p.id
                         ORDER BY p.category, p.name")->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Products & Recipes</div>
      <div class="muted">Finished goods for POS + Distribution (Bread, Cakes, Pastries)</div>
    </div>
    <a class="btn btn-primary" href="<?= esc(url('production/new_product.php')) ?>">Add Product</a>
  </div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr>
        <th>Category</th><th>SKU</th><th>Name</th><th>UoM</th><th class="text-end">Sell Price</th><th class="text-end">On Hand</th><th></th>
      </tr></thead>
      <tbody>
        <?php foreach($products as $p): ?>
          <tr>
            <td><?= esc($p['category']) ?></td>
            <td><?= esc($p['sku']) ?></td>
            <td><?= esc($p['name']) ?></td>
            <td><?= esc($p['uom']) ?></td>
            <td class="text-end"><?= esc(money($p['sell_price'])) ?></td>
            <td class="text-end"><?= esc(money($p['on_hand'])) ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-light" href="<?= esc(url('production/recipe.php?id='.(int)$p['id'])) ?>">Recipe</a>
              <a class="btn btn-sm btn-outline-light" href="<?= esc(url('production/edit_product.php?id='.(int)$p['id'])) ?>">Edit</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
