<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

$products = $pdo->query("SELECT id,name,uom FROM products WHERE is_active=1 ORDER BY category,name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $product_id = (int)($_POST['product_id'] ?? 0);
  $date = (string)($_POST['batch_date'] ?? date('Y-m-d'));
  $qty  = (float)($_POST['qty'] ?? 0);
  $notes= trim((string)($_POST['notes'] ?? ''));

  if ($product_id<=0 || $qty<=0) $err="Select product and quantity.";
  else {
    tx(function(PDO $pdo) use($product_id,$date,$qty,$notes,$u){
      // compute cost from last purchase costs (avg) * recipe usage
      $recipe = $pdo->prepare("SELECT r.item_id, r.qty_per_unit FROM recipes r WHERE r.product_id=?");
      $recipe->execute([$product_id]);
      $ings = $recipe->fetchAll();
      if (!$ings) throw new RuntimeException("Recipe missing for product. Add BOM first.");

      // avg cost per item from purchase_lines (fallback 0)
      $costStmt = $pdo->prepare("SELECT COALESCE(AVG(unit_cost),0) c FROM purchase_lines WHERE item_id=?");
      $unit_cost_total = 0.0;
      foreach($ings as $ing){
        $costStmt->execute([(int)$ing['item_id']]);
        $c = (float)($costStmt->fetch()['c'] ?? 0);
        $unit_cost_total += $c * (float)$ing['qty_per_unit'];
      }
      $unit_cost = $unit_cost_total;
      $total_cost = $unit_cost * $qty;

      $stmt = $pdo->prepare("INSERT INTO production_batches(batch_date, product_id, qty, unit_cost, total_cost, notes, created_by, created_at)
                             VALUES(?,?,?,?,?,?,?,NOW())");
      $stmt->execute([$date, $product_id, $qty, $unit_cost, $total_cost, $notes ?: null, (int)($u['id'] ?? 0)]);
      $bid = (int)$pdo->lastInsertId();

      // consume raw materials: stock_moves qty_out = qty_per_unit * batch qty
      $move = $pdo->prepare("INSERT INTO stock_moves(move_time, ref_type, ref_id, item_id, qty_in, qty_out, unit_cost, notes)
                             VALUES(NOW(),'PRODUCTION',?,?,0,?,?,?)");
      foreach($ings as $ing){
        $item_id = (int)$ing['item_id'];
        $out = (float)$ing['qty_per_unit'] * $qty;
        // use avg cost
        $costStmt->execute([$item_id]);
        $c = (float)($costStmt->fetch()['c'] ?? 0);
        $move->execute([$bid, $item_id, $out, $c, 'Consumed in production']);
      }

      // add finished goods stock
      $fin = $pdo->prepare("INSERT INTO finished_moves(move_time, ref_type, ref_id, product_id, qty_in, qty_out, unit_cost, notes)
                            VALUES(NOW(),'PRODUCTION',?,?,?,0,?,?)");
      $fin->execute([$bid, $product_id, $qty, $unit_cost, 'Produced finished goods']);
    });

    start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Production batch saved. Raw materials consumed; finished stock increased.'];
    header('Location: ' . url('production/batches.php'));
    exit;
  }
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold mb-2">Log Production Batch</div>
  <?php if (!empty($err)): ?><div class="alert alert-danger"><?= esc($err) ?></div><?php endif; ?>
  <form method="post" class="row g-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="col-md-6">
      <label class="form-label">Product</label>
      <select class="form-select" name="product_id" required>
        <option value="">Select…</option>
        <?php foreach($products as $p): ?>
          <option value="<?= (int)$p['id'] ?>"><?= esc($p['name']) ?> (<?= esc($p['uom']) ?>)</option>
        <?php endforeach; ?>
      </select>
      <div class="small muted mt-1">Make sure recipe (BOM) exists.</div>
    </div>
    <div class="col-md-3">
      <label class="form-label">Batch Date</label>
      <input class="form-control" type="date" name="batch_date" value="<?= esc($_POST['batch_date'] ?? date('Y-m-d')) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">Quantity</label>
      <input class="form-control" name="qty" type="number" step="0.01" required>
    </div>
    <div class="col-12">
      <label class="form-label">Notes</label>
      <input class="form-control" name="notes" placeholder="Shift, oven, special notes…">
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Save Batch</button>
      <a class="btn btn-outline-light" href="<?= esc(url('production/batches.php')) ?>">Back</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
