<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
$pdo = db();

$q = trim((string)($_GET['q'] ?? ''));
$params = [];
$sql = "SELECT i.*, COALESCE(s.on_hand,0) on_hand
        FROM items i
        LEFT JOIN (SELECT item_id, SUM(qty_in-qty_out) on_hand FROM stock_moves GROUP BY item_id) s ON s.item_id=i.id
        WHERE 1=1 ";
if ($q !== '') { $sql .= " AND (i.name LIKE ? OR i.sku LIKE ?) "; $params[]="%$q%"; $params[]="%$q%"; }
$sql .= " ORDER BY i.type, i.name LIMIT 500";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Inventory Items</div>
      <div class="muted">Raw materials + packaging + other inputs</div>
    </div>
    <a class="btn btn-primary" href="<?= esc(url('inventory/new_item.php')) ?>">Add Item</a>
  </div>
  <form class="mt-3" method="get">
    <input class="form-control" name="q" placeholder="Search item or SKU..." value="<?= esc($q) ?>">
  </form>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr>
        <th>Type</th><th>SKU</th><th>Name</th><th>UoM</th><th class="text-end">On Hand</th><th></th>
      </tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= esc($r['type']) ?></td>
            <td><?= esc($r['sku']) ?></td>
            <td><?= esc($r['name']) ?></td>
            <td><?= esc($r['uom']) ?></td>
            <td class="text-end"><?= esc(money($r['on_hand'])) ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-light" href="<?= esc(url('inventory/edit_item.php?id='.(int)$r['id'])) ?>">Edit</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
