<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/helpers.php';

$u = require_login(url('login.php'));
$pdo = db();

$today = date('Y-m-d');
$kpis = [
  'sales_today' => 0, 'collections_today' => 0, 'expenses_today' => 0,
  'loaves_today' => 0, 'top_due' => 0
];

$kpis['sales_today'] = (float)($pdo->query("SELECT COALESCE(SUM(total),0) t FROM pos_sales WHERE DATE(sale_time) = CURDATE()")->fetch()['t'] ?? 0);
$kpis['collections_today'] = (float)($pdo->query("SELECT COALESCE(SUM(amount),0) t FROM collections WHERE DATE(collected_at) = CURDATE()")->fetch()['t'] ?? 0);
$kpis['expenses_today'] = (float)($pdo->query("SELECT COALESCE(SUM(amount),0) t FROM expenses WHERE expense_date = CURDATE()")->fetch()['t'] ?? 0);
$kpis['loaves_today'] = (float)($pdo->query("SELECT COALESCE(SUM(qty),0) t FROM production_batches pb JOIN products p ON p.id=pb.product_id WHERE pb.batch_date=CURDATE() AND p.category='Bread'")->fetch()['t'] ?? 0);
$kpis['top_due'] = (float)($pdo->query("SELECT COALESCE(SUM(balance),0) t FROM customers WHERE balance>0")->fetch()['t'] ?? 0);

include __DIR__ . '/_layout.php';
?>
<div class="row g-3">
  <div class="col-12">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div class="fs-5 fw-semibold">Welcome, <?= esc($u['name'] ?? 'User') ?></div>
          <div class="muted">Today: <?= esc($today) ?> • Currency: KES</div>
        </div>
        <span class="badge text-bg-secondary"><?= esc($u['role'] ?? '') ?></span>
      </div>
    </div>
  </div>

  <?php
  $cards = [
    ['Sales Today', $kpis['sales_today']],
    ['Collections Today', $kpis['collections_today']],
    ['Expenses Today', $kpis['expenses_today']],
    ['Bread Produced Today', $kpis['loaves_today']],
    ['Customer Outstanding', $kpis['top_due']],
  ];
  foreach ($cards as $c):
  ?>
  <div class="col-12 col-md-6 col-lg-4">
    <div class="card p-3">
      <div class="muted"><?= esc($c[0]) ?></div>
      <div class="fs-4 fw-semibold"><?= esc(money($c[1])) ?></div>
    </div>
  </div>
  <?php endforeach; ?>

  <div class="col-12">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center mb-2">
        <div class="fw-semibold">Quick Actions</div>
      </div>
      <div class="d-flex gap-2 flex-wrap">
        <a class="btn btn-primary" href="<?= esc(url('purchases/receive.php')) ?>">Receive Purchase</a>
        <a class="btn btn-outline-light" href="<?= esc(url('production/batches.php')) ?>">Log Production</a>
        <a class="btn btn-outline-light" href="<?= esc(url('pos/new_sale.php')) ?>">New POS Sale</a>
        <a class="btn btn-outline-light" href="<?= esc(url('distribution/new_trip.php')) ?>">New Distribution Trip</a>
        <a class="btn btn-outline-light" href="<?= esc(url('expenses/new_expense.php')) ?>">New Expense</a>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/_footer.php'; ?>
