<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $date = (string)($_POST['expense_date'] ?? date('Y-m-d'));
  $cat  = (string)($_POST['category'] ?? 'General');
  $desc = trim((string)($_POST['description'] ?? ''));
  $amt  = (float)($_POST['amount'] ?? 0);
  $pay  = (string)($_POST['payment_method'] ?? 'Cash');

  $stmt = $pdo->prepare("INSERT INTO expenses(expense_date, category, description, amount, payment_method, created_by, created_at)
                         VALUES(?,?,?,?,?,?,NOW())");
  $stmt->execute([$date,$cat,$desc,$amt,$pay,(int)($u['id'] ?? 0)]);

  start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Expense saved.'];
  header('Location: ' . url('expenses/expenses.php'));
  exit;
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold mb-2">New Expense</div>
  <form method="post" class="row g-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="col-md-3">
      <label class="form-label">Date</label>
      <input class="form-control" type="date" name="expense_date" value="<?= esc($_POST['expense_date'] ?? date('Y-m-d')) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">Category</label>
      <select class="form-select" name="category">
        <?php foreach(['Fuel','Salaries','Electricity','Rent','Repairs','Packaging','Transport','General'] as $c): ?>
          <option><?= esc($c) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Payment</label>
      <select class="form-select" name="payment_method">
        <option>Cash</option><option>M-Pesa</option><option>Bank</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Amount (KES)</label>
      <input class="form-control" name="amount" type="number" step="0.01" required>
    </div>
    <div class="col-12">
      <label class="form-label">Description</label>
      <input class="form-control" name="description" placeholder="e.g. Fuel for Van KCA 123A">
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-light" href="<?= esc(url('expenses/expenses.php')) ?>">Back</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
