<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
$pdo = db();

$rows = $pdo->query("SELECT t.*, r.name route
                     FROM trips t
                     LEFT JOIN routes r ON r.id=t.route_id
                     ORDER BY t.id DESC LIMIT 200")->fetchAll();

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Distribution Trips</div>
      <div class="muted">Loads → sales → returns → collections per route/vehicle</div>
    </div>
    <a class="btn btn-primary" href="<?= esc(url('distribution/new_trip.php')) ?>">New Trip</a>
  </div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr>
        <th>Date</th><th>Route</th><th>Vehicle</th><th>Sales Rep</th><th class="text-end">Loaded</th><th class="text-end">Sold</th><th class="text-end">Returned</th><th class="text-end">Collected</th><th></th>
      </tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= esc($r['trip_date']) ?></td>
            <td><?= esc($r['route'] ?? '-') ?></td>
            <td><?= esc($r['vehicle']) ?></td>
            <td><?= esc($r['sales_rep']) ?></td>
            <td class="text-end"><?= esc(money($r['loaded_total'])) ?></td>
            <td class="text-end"><?= esc(money($r['sold_total'])) ?></td>
            <td class="text-end"><?= esc(money($r['returned_total'])) ?></td>
            <td class="text-end"><?= esc(money($r['collected_total'])) ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-light" href="<?= esc(url('distribution/trip_view.php?id='.(int)$r['id'])) ?>">Open</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../_footer.php'; ?>
