<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT t.*, r.name route FROM trips t LEFT JOIN routes r ON r.id=t.route_id WHERE t.id=?");
$stmt->execute([$id]);
$trip = $stmt->fetch();
if (!$trip) { http_response_code(404); exit('Trip not found'); }

$lines = $pdo->prepare("SELECT tl.*, p.name, p.uom FROM trip_lines tl JOIN products p ON p.id=tl.product_id WHERE tl.trip_id=? ORDER BY p.name");
$lines->execute([$id]);
$rows = $lines->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // save sold / returned / collections
  $post = (array)($_POST['lines'] ?? []);
  $pay_method = (string)($_POST['payment_method'] ?? 'Cash');
  $amount = (float)($_POST['amount'] ?? 0);
  $mpesa_ref = trim((string)($_POST['mpesa_ref'] ?? ''));

  tx(function(PDO $pdo) use($id,$post,$amount,$pay_method,$mpesa_ref,$u){
    $upd = $pdo->prepare("UPDATE trip_lines SET sold_qty=?, returned_qty=? WHERE id=? AND trip_id=?");
    $pPrice = $pdo->prepare("SELECT unit_price FROM trip_lines WHERE id=? AND trip_id=?");
    $sold_total = 0.0;
    $returned_total = 0.0;
    foreach($post as $lid=>$ln){
      $sold = (float)($ln['sold_qty'] ?? 0);
      $ret  = (float)($ln['returned_qty'] ?? 0);
      $upd->execute([$sold, $ret, (int)$lid, $id]);
      $pPrice->execute([(int)$lid, $id]);
      $price = (float)($pPrice->fetch()['unit_price'] ?? 0);
      $sold_total += $sold * $price;
      $returned_total += $ret * $price;
      // returned stock goes back to finished goods
      if ($ret > 0) {
        $pdo->prepare("INSERT INTO finished_moves(move_time, ref_type, ref_id, product_id, qty_in, qty_out, unit_cost, notes)
                       SELECT NOW(),'TRIP_RETURN', ?, product_id, ?, 0, 0, 'Returned from trip'
                       FROM trip_lines WHERE id=? AND trip_id=?")
            ->execute([$id, $ret, (int)$lid, $id]);
      }
    }

    if ($amount > 0) {
      $pdo->prepare("INSERT INTO collections(collected_at, ref_type, ref_id, payment_method, mpesa_ref, amount, received_by, notes)
                     VALUES(NOW(),'TRIP',?,?,?,?,?,?)")
          ->execute([$id, $pay_method, $mpesa_ref ?: null, $amount, (int)($u['id'] ?? 0), 'Route collections']);
    }

    $col = (float)($pdo->query("SELECT COALESCE(SUM(amount),0) t FROM collections WHERE ref_type='TRIP' AND ref_id={$id}")->fetch()['t'] ?? 0);
    $pdo->prepare("UPDATE trips SET sold_total=?, returned_total=?, collected_total=? WHERE id=?")
        ->execute([$sold_total, $returned_total, $col, $id]);
  });

  start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Trip updated (sold/returns/collections).'];
  header('Location: ' . url('distribution/trip_view.php?id='.$id));
  exit;
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Trip #<?= (int)$trip['id'] ?> • <?= esc($trip['trip_date']) ?> • <?= esc($trip['route'] ?? '-') ?></div>
      <div class="muted">Vehicle: <?= esc($trip['vehicle']) ?> • Rep: <?= esc($trip['sales_rep']) ?></div>
    </div>
    <a class="btn btn-outline-light" href="<?= esc(url('distribution/trips.php')) ?>">Back</a>
  </div>
</div>

<?php include __DIR__ . '/../_flash.php'; ?>

<form method="post" class="row g-3">
  <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">

  <div class="col-12">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Lines (Loaded / Sold / Returned)</div>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr>
            <th>Product</th><th class="text-end">Loaded</th><th class="text-end">Sold</th><th class="text-end">Returned</th>
          </tr></thead>
          <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?= esc($r['name']) ?> <span class="muted">(<?= esc($r['uom']) ?>)</span></td>
                <td class="text-end"><?= esc(money($r['loaded_qty'])) ?></td>
                <td class="text-end"><input class="form-control form-control-sm text-end" name="lines[<?= (int)$r['id'] ?>][sold_qty]" type="number" step="0.01" value="<?= esc($r['sold_qty']) ?>"></td>
                <td class="text-end"><input class="form-control form-control-sm text-end" name="lines[<?= (int)$r['id'] ?>][returned_qty]" type="number" step="0.01" value="<?= esc($r['returned_qty']) ?>"></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Add Collection (optional)</div>
      <div class="row g-2">
        <div class="col-md-4">
          <label class="form-label">Payment</label>
          <select class="form-select" name="payment_method">
            <option>Cash</option><option>M-Pesa</option><option>Bank</option>
          </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">Amount (KES)</label>
          <input class="form-control" name="amount" type="number" step="0.01" value="0">
        </div>
        <div class="col-md-4">
          <label class="form-label">M-Pesa Ref</label>
          <input class="form-control" name="mpesa_ref">
        </div>
      </div>
      <div class="small muted mt-2">Tip: Enter daily total cash/M-Pesa collected by the route.</div>
    </div>
  </div>

  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Trip Totals</div>
      <div class="d-flex justify-content-between"><span class="muted">Loaded</span><span><?= esc(money($trip['loaded_total'])) ?></span></div>
      <div class="d-flex justify-content-between"><span class="muted">Sold</span><span><?= esc(money($trip['sold_total'])) ?></span></div>
      <div class="d-flex justify-content-between"><span class="muted">Returned</span><span><?= esc(money($trip['returned_total'])) ?></span></div>
      <div class="d-flex justify-content-between"><span class="muted">Collected</span><span><?= esc(money($trip['collected_total'])) ?></span></div>
      <div class="small muted mt-2">Sold/Returned update from lines. Collections update from collection entry.</div>
    </div>
  </div>

  <div class="col-12">
    <button class="btn btn-primary">Save Updates</button>
  </div>
</form>

<?php include __DIR__ . '/../_footer.php'; ?>
