<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/helpers.php';

$u = require_login(url('login.php'));
csrf_check();
$pdo = db();

$routes = $pdo->query("SELECT id,name FROM routes ORDER BY name")->fetchAll();
$products = $pdo->query("SELECT id,name,uom,sell_price FROM products WHERE is_active=1 ORDER BY category,name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $date = (string)($_POST['trip_date'] ?? date('Y-m-d'));
  $route_id = (int)($_POST['route_id'] ?? 0) ?: null;
  $vehicle = trim((string)($_POST['vehicle'] ?? ''));
  $rep = trim((string)($_POST['sales_rep'] ?? ''));
  $lines = (array)($_POST['lines'] ?? []);

  $clean = [];
  foreach($lines as $ln){
    $product_id = (int)($ln['product_id'] ?? 0);
    $qty = (float)($ln['qty'] ?? 0);
    if ($product_id>0 && $qty>0) $clean[]=['product_id'=>$product_id,'qty'=>$qty];
  }
  if (!$clean) $err='Add at least one load line.';
  else {
    tx(function(PDO $pdo) use($date,$route_id,$vehicle,$rep,$clean,$u){
      $stmt = $pdo->prepare("INSERT INTO trips(trip_date, route_id, vehicle, sales_rep, status, created_by, created_at)
                             VALUES(?,?,?,?, 'Open', ?, NOW())");
      $stmt->execute([$date,$route_id,$vehicle,$rep,(int)($u['id'] ?? 0)]);
      $tid = (int)$pdo->lastInsertId();

      $pPrice = $pdo->prepare("SELECT sell_price FROM products WHERE id=?");
      $insL = $pdo->prepare("INSERT INTO trip_lines(trip_id, product_id, loaded_qty, unit_price) VALUES(?,?,?,?)");
      $finMove = $pdo->prepare("INSERT INTO finished_moves(move_time, ref_type, ref_id, product_id, qty_in, qty_out, unit_cost, notes)
                                VALUES(NOW(),'TRIP_LOAD',?,?,0,?,0,'Loaded for distribution')");
      $loaded_total = 0.0;

      foreach($clean as $c){
        $pPrice->execute([$c['product_id']]);
        $price = (float)($pPrice->fetch()['sell_price'] ?? 0);
        $insL->execute([$tid, $c['product_id'], $c['qty'], $price]);
        $finMove->execute([$tid, $c['product_id'], $c['qty']]);
        $loaded_total += $c['qty'] * $price;
      }
      $pdo->prepare("UPDATE trips SET loaded_total=? WHERE id=?")->execute([$loaded_total, $tid]);
    });

    start_session(); $_SESSION['flash']=['type'=>'success','msg'=>'Trip created and stock deducted (loaded).'];
    header('Location: ' . url('distribution/trips.php'));
    exit;
  }
}

include __DIR__ . '/../_layout.php';
?>
<div class="card p-3">
  <div class="fw-semibold mb-1">New Distribution Trip</div>
  <div class="muted mb-3">Create load sheet for van/rider</div>
  <?php if (!empty($err)): ?><div class="alert alert-danger"><?= esc($err) ?></div><?php endif; ?>
  <form method="post" class="row g-3">
    <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
    <div class="col-md-3">
      <label class="form-label">Date</label>
      <input class="form-control" type="date" name="trip_date" value="<?= esc($_POST['trip_date'] ?? date('Y-m-d')) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Route</label>
      <select class="form-select" name="route_id">
        <option value="">—</option>
        <?php foreach($routes as $r): ?>
          <option value="<?= (int)$r['id'] ?>"><?= esc($r['name']) ?></option>
        <?php endforeach; ?>
      </select>
      <div class="small muted mt-1"><a href="<?= esc(url('settings/routes.php')) ?>">Manage routes</a></div>
    </div>
    <div class="col-md-3">
      <label class="form-label">Vehicle</label>
      <input class="form-control" name="vehicle" placeholder="KCA 123A">
    </div>
    <div class="col-md-2">
      <label class="form-label">Sales Rep</label>
      <input class="form-control" name="sales_rep" placeholder="Driver / Rider">
    </div>

    <div class="col-12">
      <div class="fw-semibold mb-2">Load Lines</div>
      <div id="lines"></div>
      <button type="button" class="btn btn-outline-light" onclick="addLine()">+ Add Product</button>
    </div>

    <div class="col-12">
      <button class="btn btn-primary">Create Trip</button>
      <a class="btn btn-outline-light" href="<?= esc(url('distribution/trips.php')) ?>">Back</a>
    </div>
  </form>
</div>

<script>
const products = <?= json.dumps(array_map(fn($p)=>['id'=>(int)$p['id'],'name'=>$p['name'],'uom'=>$p['uom']], $products)) ?>;
function addLine(){
  const wrap = document.getElementById('lines');
  const idx = wrap.children.length;
  const div = document.createElement('div');
  div.className='row g-2 mb-2';
  div.innerHTML = `
    <div class="col-md-8">
      <select class="form-select" name="lines[${idx}][product_id]" required>
        <option value="">Select product…</option>
        ${products.map(p=>`<option value="${p.id}">${p.name} (${p.uom})</option>`).join('')}
      </select>
    </div>
    <div class="col-md-4">
      <input class="form-control" name="lines[${idx}][qty]" type="number" step="0.01" placeholder="Qty" required>
    </div>`;
  wrap.appendChild(div);
}
addLine();
</script>
<?php include __DIR__ . '/../_footer.php'; ?>
