<?php
declare(strict_types=1);

function esc($v): string { return htmlspecialchars((string)($v ?? ''), ENT_QUOTES, 'UTF-8'); }
function money($v): string { return number_format((float)$v, 2); }

function base_path(): string {
  $cfg = require __DIR__ . '/config.php';
  return rtrim((string)$cfg['base_path'], '/');
}

function url(string $path): string {
  return base_path() . '/' . ltrim($path, '/');
}

function now(): string { return date('Y-m-d H:i:s'); }

function kenya_phone_normalize(string $phone): string {
  $p = preg_replace('/\s+/', '', $phone);
  $p = preg_replace('/[^0-9+]/', '', $p);
  if (str_starts_with($p, '07') && strlen($p) === 10) return '+254' . substr($p, 1);
  if (str_starts_with($p, '01') && strlen($p) === 10) return '+254' . substr($p, 1);
  if (str_starts_with($p, '254') && strlen($p) === 12) return '+' . $p;
  return $p;
}
